/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ortholog;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.primefaces.model.TreeNode;
import org.rhwlab.UCSC.AggregateBed;
import org.rhwlab.UCSC.TrackHub;
import org.rhwlab.encode.qa.ChipSeqUpload;
import org.rhwlab.modern.ControlFile;
import org.rhwlab.modern.DCCFile;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.ExperimentalFile;
import org.rhwlab.modern.FileType;
import org.rhwlab.modern.FlyService;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.OrthologTF;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.Species;
import org.rhwlab.modern.SpeciesService;
import org.rhwlab.modern.TF;
import org.rhwlab.modern.ViewByTF;
import org.rhwlab.modern.WormService;

public class OrthologService
implements Serializable,
Runnable {
    static String[] wormAssembly = new String[]{"ce10", "ce11"};
    static String[] flyAssembly = new String[]{"dm3", "dm6"};
    File hubDir;
    Map<String, List<String>> flyOrthologs;
    Map<String, List<String>> wormOrthologs;
    WormService wormService = new WormService();
    FlyService flyService = new FlyService();
    Date updated;

    public OrthologService() throws Exception {
        this(true);
    }

    public OrthologService(boolean updating) throws Exception {
        if (updating) {
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
            executor.scheduleAtFixedRate(this, 0L, 24L, TimeUnit.HOURS);
        }
        this.hubDir = new File("/data/www/site/waterston/html/modERN");
        this.hubDir = new File("/net/waterston/vol2/home/gevirl/trackhubs/modERN");
        this.buildIt();
    }

    @Override
    public void run() {
        try {
            this.updated = new Date();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void checkUploadStatus(File dir) throws Exception {
        PrintStream stream = new PrintStream(new File(dir, "WormMissingReport"));
        for (Experiment exp : this.wormService.getExperiments()) {
            if (exp.isControl()) continue;
            ChipSeqUpload wormUpload = new ChipSeqUpload(exp, wormAssembly, stream);
            wormUpload.reportExperimentIP();
        }
        stream.close();
        stream = new PrintStream(new File(dir, "FlyMissingReport"));
        for (Experiment exp : this.flyService.getExperiments()) {
            if (exp.isControl()) continue;
            ChipSeqUpload flyUpload = new ChipSeqUpload(exp, flyAssembly, stream);
            flyUpload.reportExperimentIP();
        }
        stream.close();
    }

    private void formTrackHub(File hubDir, String species, String[] assemblies, OrthologService service) throws Exception {
        TreeMap<String, TF> tfs = new TreeMap<String, TF>();
        ViewByTF[] views = new ViewByTF[assemblies.length];
        TreeNode[] roots = new TreeNode[assemblies.length];
        for (int a = 0; a < assemblies.length; ++a) {
            String assembly = assemblies[a];
            File assemblyDir = new File(hubDir, assembly);
            ReferenceGenome refGenome = new ReferenceGenome();
            refGenome.setAssembly(species, assembly);
            views[a] = new ViewByTF();
            views[a].setSpecies(species);
            views[a].setGenomes(refGenome);
            views[a].setService(service);
            roots[a] = views[a].getRoot();
            for (TreeNode node : views[a].getRoot().getChildren()) {
                TF tf = (TF)node.getData();
                tfs.put(tf.getId(), tf);
            }
            AggregateBed aggBed = new AggregateBed(views[a].getRoot(), "optimal idr thresholded peaks", "gz");
            File narrowBedFile = new File(assemblyDir, "narrowPeak.bed");
            File narrowBBFile = new File(assemblyDir, "narrowPeak.bb");
            File singleBedFile = new File(assemblyDir, "singlePeak.bed");
            File singleBBFile = new File(assemblyDir, "singlePeak.bb");
            aggBed.writeTo(narrowBedFile);
            String cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+4 -as=/net/waterston/vol9/narrowPeak.as  %s /net/waterston/vol9/%s.chrom.sizes %s", narrowBedFile.getPath(), assembly, narrowBBFile.getPath());
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            aggBed.writePointBedTo(singleBedFile);
            cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+3  %s /net/waterston/vol9/%s.chrom.sizes %s", singleBedFile.getPath(), assembly, singleBBFile.getPath());
            p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            Runtime.getRuntime().exec(String.format("chmod 666 %s", narrowBBFile.getPath()));
            Runtime.getRuntime().exec(String.format("chmod 666 %s", singleBBFile.getPath()));
        }
        for (String tf : tfs.keySet()) {
            TrackHub.formHub(tf, roots, hubDir, species, assemblies);
            TrackHub.formTFhtml((TF)tfs.get(tf), hubDir);
        }
        TrackHub.formHub(null, roots, hubDir, species, assemblies);
    }

    private void buildIt() throws Exception {
        this.wormService.run();
        this.flyService.run();
        this.flyOrthologs = this.buildOrthologMap("/org/rhwlab/encode/ortholog/FBgnToWBGene.all.orthologs", this.flyService, this.wormService);
        this.wormOrthologs = this.buildOrthologMap("/org/rhwlab/encode/ortholog/WBGeneToFBgn.all.orthologs", this.wormService, this.flyService);
        for (Experiment exp : this.wormService.getAllExperiments()) {
            if (exp.getDbxref() != null) {
                exp.setOrthologs(this.getWormOrthologsCommonName(exp.getDbxref()));
                continue;
            }
            System.out.printf("No dbxref for %s\n", exp.getAccession());
        }
        for (Experiment exp : this.flyService.getAllExperiments()) {
            if (exp.getDbxref() != null) {
                exp.setOrthologs(this.getFlyOrthologsCommonName(exp.getDbxref()));
                continue;
            }
            System.out.printf("No dbxref for %s\n", exp.getAccession());
        }
    }

    private TreeMap buildOrthologMap(String file, SpeciesService service1, SpeciesService service2) throws Exception {
        TreeMap<String, ArrayList<String>> ret = new TreeMap<String, ArrayList<String>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file)));
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split("\t");
            if (service1.inDB(tokens[0]) && service2.inDB(tokens[1])) {
                ArrayList<String> list = (ArrayList<String>)ret.get(tokens[0]);
                if (list == null) {
                    list = new ArrayList<String>();
                    ret.put(tokens[0], list);
                }
                list.add(tokens[1]);
            }
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }

    public TreeNode createTree(String species, String genome) {
        SpeciesService service = this.wormService;
        if (species.equals("fly")) {
            service = this.flyService;
        }
        List tfs = service.getAllTFs();
        return this.createTree(species, tfs, genome);
    }

    public TreeNode createTree(String species, List<String> tfs, String genome) {
        SpeciesService service = this.wormService;
        if (species.equals("fly")) {
            service = this.flyService;
        }
        Species root = new Species(genome, species, null);
        for (String gene : tfs) {
            TF geneNode = null;
            TreeMap<String, List<Experiment>> stages = service.getExpByStage(gene);
            for (String stage : stages.keySet()) {
                List<Experiment> exps = stages.get(stage);
                for (Experiment exp : exps) {
                    if (geneNode == null) {
                        if (this.getOrthologs(exp.getDbxref()).isEmpty()) {
                            geneNode = new TF(genome, gene, (TreeNode)root, service.getGeneType(gene));
                        } else {
                            geneNode = new OrthologTF(genome, gene, (TreeNode)root, service.getGeneType(gene));
                            ((OrthologTF)geneNode).setOrthologs(this.getOrthologsCommonName(exp.getDbxref()));
                        }
                    }
                    geneNode.setDbxref(exp.getDbxref());
                    LifeStage stageNode = new LifeStage(genome, exp, (TreeNode)geneNode);
                    this.addFiles((TreeNode)stageNode, exp, genome);
                }
            }
        }
        return root;
    }

    public TreeNode createByStageTree(String species, String genome) {
        SpeciesService service = this.wormService;
        if (species.equals("fly")) {
            service = this.flyService;
        }
        Species root = new Species(genome, species, null);
        for (String stage : service.getAllStages()) {
            LifeStage stageNode = new LifeStage(stage, (TreeNode)root);
            TreeMap<String, List<Experiment>> tfs = service.getExpByTF(stage);
            for (String tf : tfs.keySet()) {
                List<Experiment> exps = tfs.get(tf);
                for (Experiment exp : exps) {
                    TF tfNode;
                    if (this.getOrthologs(exp.getDbxref()).isEmpty()) {
                        tfNode = new TF(genome, exp, (TreeNode)stageNode, service.getGeneType(tf));
                    } else {
                        tfNode = new OrthologTF(genome, exp, (TreeNode)stageNode, service.getGeneType(tf));
                        ((OrthologTF)tfNode).setOrthologs(this.getOrthologsCommonName(exp.getDbxref()));
                    }
                    this.addFiles((TreeNode)tfNode, exp, genome);
                }
            }
        }
        return root;
    }

    public void addFiles(TreeNode root, Experiment exp, String genome) {
        TreeMap<String, List<DCCFile>> fileMap = new TreeMap<String, List<DCCFile>>();
        this.mapFilesForAccession(exp, genome, fileMap);
        TreeMap<String, List<DCCFile>> controlFileMap = new TreeMap<String, List<DCCFile>>();
        if (exp.getInput() != null) {
            this.mapFilesForAccession(exp.getInput(), genome, controlFileMap);
        }
        for (String key : fileMap.keySet()) {
            List<DCCFile> list = fileMap.get(key);
            FileType keyNode = new FileType(key, genome, root);
            for (DCCFile file : list) {
                ExperimentalFile experimentalFile = new ExperimentalFile(file, (TreeNode)keyNode);
            }
            List<DCCFile> cFiles = controlFileMap.get(key);
            if (cFiles == null) continue;
            for (DCCFile file : cFiles) {
                ControlFile controlFile = new ControlFile(file, (TreeNode)keyNode);
            }
        }
    }

    private void mapFilesForAccession(Experiment exp, String genome, TreeMap<String, List<DCCFile>> fileMap) {
        DCCFile[] files = exp.getFiles();
        for (int i = 0; i < files.length; ++i) {
            String assembly = files[i].getAssembly();
            if (assembly != null && !assembly.equals(genome)) continue;
            String key = files[i].getOutputType();
            List<DCCFile> list = fileMap.get(key);
            if (list == null) {
                list = new ArrayList<DCCFile>();
                fileMap.put(key, list);
            }
            list.add(files[i]);
        }
    }

    public List<String> getFlyOrthologsCommonName(String flydbxref) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String dbxref : this.getFlyOrthologs(flydbxref)) {
            String commonName = this.wormService.getCommonName(dbxref);
            if (commonName == null) continue;
            ret.add(commonName);
        }
        return ret;
    }

    public List<String> getWormOrthologsCommonName(String wormdbxref) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String dbxref : this.getWormOrthologs(wormdbxref)) {
            String commonName = this.flyService.getCommonName(dbxref);
            if (commonName == null) continue;
            ret.add(commonName);
        }
        return ret;
    }

    public List<String> getOrthologs(String id) {
        List<String> ret = this.getWormOrthologs(id);
        if (ret.isEmpty()) {
            ret = this.getFlyOrthologs(id);
        }
        return ret;
    }

    public List<String> getOrthologsCommonName(String dbxref) {
        List<String> ret = this.getWormOrthologsCommonName(dbxref);
        if (ret.isEmpty()) {
            ret = this.getFlyOrthologsCommonName(dbxref);
        }
        return ret;
    }

    public List<String> getWormOrthologs(String dbxref) {
        List<String> ret = this.wormOrthologs.get(dbxref);
        if (ret == null) {
            ret = new ArrayList<String>();
        }
        return ret;
    }

    public List<String> getFlyOrthologs(String dbxref) {
        List<String> ret = this.flyOrthologs.get(dbxref);
        if (ret == null) {
            ret = new ArrayList<String>();
        }
        return ret;
    }

    public String getCommonName(String dbxrefName) {
        String ret = this.flyService.getCommonName(dbxrefName);
        if (ret == null) {
            ret = this.wormService.getCommonName(dbxrefName);
        }
        return ret;
    }

    public String getUpdatedLast() {
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        if (this.updated == null) {
            return "currently being updated - try again later";
        }
        return df.format(this.updated);
    }

    public static void main(String[] args) throws Exception {
        OrthologService service = new OrthologService(false);
        service.buildIt();
        service.checkUploadStatus(new File("/net/waterston/vol2/home/gevirl"));
        boolean iasdhfu = false;
    }
}

