/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.objects;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.Date;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonWriter;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.rhwlab.encode.EncodeUrl;
import org.rhwlab.encode.RNASeq.UrlDisplay;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.encode.objects.WormDonor;

public class Selection
implements Serializable {
    Class<EncodeObject> encodeObjectClass;
    File directory;
    File[] files;
    JTable table;

    public Selection(File dir, Class c) throws Exception {
        this.directory = dir;
        this.encodeObjectClass = c;
        this.files = dir.listFiles();
    }

    public Selection(Class c) throws Exception {
        this.encodeObjectClass = c;
    }

    public int getObjectCount() {
        return this.files.length;
    }

    public EncodeObject getEncodeObject(String acc) throws Exception {
        return this.getEncodeObject(new File(this.directory, acc));
    }

    public EncodeObject getEncodeObject(File acc) throws Exception {
        JsonReader reader = Json.createReader(new FileInputStream(acc));
        JsonObject jsonObj = reader.readObject();
        reader.close();
        EncodeObject ret = this.encodeObjectClass.newInstance();
        ret.setJsonObject(jsonObj);
        boolean isdertertfg = false;
        return ret;
    }

    public EncodeObject getEncodeObject(int i) throws Exception {
        return this.getEncodeObject(this.files[i]);
    }

    public void saveToDirectory(File dir) throws Exception {
        this.saveToDirectory(dir, true);
    }

    public void saveToDirectory(File dir, boolean expand) throws Exception {
        Path outPath = null;
        EncodeObject obj = this.encodeObjectClass.newInstance();
        EncodeUrl url = new EncodeUrl(obj.getSelectionUrl());
        url.getJson();
        JsonObject jsonObj = url.getJsonObject();
        JsonArray list = jsonObj.getJsonArray("@graph");
        for (int i = 0; i < list.size(); ++i) {
            JsonObject listObj = list.getJsonObject(i);
            JsonString jsonAcc = listObj.getJsonString("@id");
            if (jsonAcc != null) {
                String id = jsonAcc.getString();
                JsonObject fromEncode = EncodeObject.getFromEncode(id);
                obj = this.encodeObjectClass.newInstance();
                obj.setJsonObject(fromEncode);
                obj.expand();
                boolean asiofjisd = false;
                File outFile = new File(dir, id);
                outPath = outFile.toPath();
                Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                PrintStream stream = new PrintStream(outFile);
                JsonWriter writer = Json.createWriter(stream);
                writer.write(obj.getJsonObject());
                stream.println();
                stream.flush();
                writer.close();
                continue;
            }
            boolean bl = false;
        }
        this.directory = outPath.getParent().toFile();
        this.files = this.directory.listFiles();
    }

    public JScrollPane toTable() throws Exception {
        TableColumn column;
        int c;
        TreeSet<String> columnSet = new TreeSet<String>();
        this.table = new JTable();
        DefaultTableModel model = new DefaultTableModel();
        for (int r = 0; r < this.getObjectCount(); ++r) {
            EncodeObject obj = this.getEncodeObject(r);
            TreeMap<String, Object> map = obj.asMap();
            if (map.isEmpty()) continue;
            this.addColumns(map, model, columnSet);
            model.addRow(obj.asMap().values().toArray());
        }
        this.table.setModel(model);
        TableCellRenderer headRend = this.table.getTableHeader().getDefaultRenderer();
        for (c = 0; c < this.table.getColumnCount(); ++c) {
            column = this.table.getColumnModel().getColumn(c);
            int headWidth = headRend.getTableCellRendererComponent((JTable)this.table, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
            int cellWidth = this.table.getDefaultRenderer(model.getColumnClass((int)c)).getTableCellRendererComponent((JTable)this.table, (Object)this.longestValue((JTable)this.table, (int)c), (boolean)false, (boolean)false, (int)0, (int)c).getPreferredSize().width;
            column.setPreferredWidth(Math.max(headWidth, cellWidth));
        }
        for (c = 0; c < this.table.getColumnCount(); ++c) {
            column = this.table.getColumnModel().getColumn(c);
            String head = (String)column.getHeaderValue();
            if (!head.contains("Accession")) continue;
            column.setCellEditor(new UrlDisplay());
        }
        this.table.setAutoCreateRowSorter(true);
        this.table.setAutoResizeMode(0);
        return new JScrollPane(this.table);
    }

    private void addColumns(TreeMap<String, Object> map, DefaultTableModel model, TreeSet<String> columnSet) {
        for (String key : map.keySet()) {
            if (columnSet.contains(key)) continue;
            columnSet.add(key);
            model.addColumn(key);
        }
    }

    private String longestValue(JTable table, int c) {
        Object longest = null;
        int len = 0;
        for (int r = 0; r < table.getRowCount(); ++r) {
            int l;
            Object obj = table.getValueAt(r, c);
            if (obj == null || (l = obj.toString().length()) <= len) continue;
            longest = obj;
            len = l;
        }
        if (longest == null) {
            return "";
        }
        return longest.toString();
    }

    public String getDirectory() {
        return this.directory.getPath();
    }

    public void setDirectory(String dir) {
        this.directory = new File(dir);
        this.files = this.directory.listFiles();
    }

    public String getUpdatedLast() {
        long l = this.directory.getParentFile().lastModified();
        Date updated = new Date(l);
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        return df.format(updated);
    }

    public JTable getTable() {
        return this.table;
    }

    public static void main(String[] args) throws Exception {
        WormDonor f = new WormDonor();
        Selection select = new Selection(f.getClass());
        select.saveToDirectory(new File("/nfs/waterston/DCCKnockDown"));
        boolean iusadfhiu = false;
    }
}

