/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;
import org.rhwlab.encode.RNASeq.LocalReplicate;
import org.rhwlab.encode.objects.Biosample;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.encode.objects.Experiment;
import org.rhwlab.encode.objects.Library;

public class Replicate
extends EncodeObject {
    public Replicate() {
    }

    public Replicate(JsonObject o) {
        this();
        this.jsonObj = o;
    }

    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=Replicate&library.award=%2Fawards%2FU41HG007355%2F&library.lab=%2Flabs%2Frobert-waterston%2F&limit=all&format=json";
    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.putAll(new Experiment(this.jsonObj.getJsonObject("experiment")).asMap());
        map.putAll(new Library(this.jsonObj.getJsonObject("library")).asMap());
        map.put("ReplicateBio", Integer.toString(this.jsonObj.getInt("biological_replicate_number")));
        map.put("ReplicateTech", Integer.toString(this.jsonObj.getInt("technical_replicate_number")));
        map.put("ReplicateUUID", this.jsonObj.getString("uuid"));
        String alias = this.getWaterstonAlias();
        map.put("ReplicateAlias", alias);
        try {
            LocalReplicate local = new LocalReplicate(alias);
            map.putAll(local.getSummary());
        }
        catch (Exception ex) {
            Logger.getLogger(Biosample.class.getName()).log(Level.SEVERE, null, ex);
        }
        return map;
    }

    @Override
    public void expand() {
    }
}

