/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.rhwlab.encode.RNASeq.LocalLibrary;
import org.rhwlab.encode.objects.Biosample;
import org.rhwlab.encode.objects.EncodeObject;

public class Library
extends EncodeObject {
    public Library() {
    }

    public Library(JsonObject o) {
        this();
        this.jsonObj = o;
    }

    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=Library&award=%2Fawards%2FU41HG007355%2F&submitted_by=%2Fusers%2F8cab8958-22c9-4b27-ba37-7696e8b604c4%2F&limit=all&format=json";
    }

    @Override
    public TreeMap<String, Object> asMap() {
        if (this.jsonObj.getString("accession").equals("ENCLB253JEF")) {
            boolean bl = false;
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String alias = this.getWaterstonAlias();
        map.put("LibraryStatus", this.jsonObj.getString("status"));
        map.put("LibraryDocuments", Integer.toString(this.jsonObj.getJsonArray("documents").size()));
        map.put("LibraryAlias", alias);
        map.put("LibraryAccession", this.jsonObj.getString("accession"));
        JsonValue biosample = (JsonValue)this.jsonObj.get("biosample");
        if (biosample instanceof JsonObject) {
            map.putAll(new Biosample(this.jsonObj.getJsonObject("biosample")).asMap());
        } else if (biosample instanceof JsonString) {
            map.put("BiosampleAccession", ((JsonString)biosample).getString().split("/")[2]);
        }
        try {
            LocalLibrary local = new LocalLibrary(alias);
            map.putAll(local.getSummary());
        }
        catch (Exception ex) {
            Logger.getLogger(Biosample.class.getName()).log(Level.SEVERE, null, ex);
        }
        return map;
    }

    @Override
    public void expand() {
    }
}

