/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.rhwlab.encode.RNASeq.LocalSequencing;
import org.rhwlab.encode.objects.Audit;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.encode.objects.Replicate;

public class File
extends EncodeObject {
    public File() {
    }

    public File(JsonObject o) {
        this();
        this.jsonObj = o;
    }

    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=File&award.project=modERN&lab.title=Robert+Waterston%2C+UW&limit=all&format=json";
    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        JsonObject rep = this.jsonObj.getJsonObject("replicate");
        if (rep != null) {
            block11: {
                map.put("SubmittedFile", this.jsonObj.getString("submitted_file_name"));
                map.put("FileStatus", this.jsonObj.getString("status"));
                JsonString acc = this.jsonObj.getJsonString("accession");
                if (acc != null) {
                    map.put("FileAccession", this.jsonObj.getString("accession"));
                } else {
                    map.put("FileAccession", "");
                }
                map.put("Format", this.jsonObj.getString("file_format"));
                map.put("MD5", this.jsonObj.getString("md5sum"));
                String alias = this.getWaterstonAlias();
                if (alias != null) {
                    map.put("FileAlias", alias);
                    try {
                        LocalSequencing localSeq = new LocalSequencing(alias);
                        TreeMap<String, String> localMap = localSeq.getSummary();
                        map.putAll(localMap);
                        if (localMap.get("LocalFileAccession").equals(map.get("FileAccession"))) {
                            map.put("LocalAccessionMatches", "matched");
                        } else {
                            map.put("LocalAccessionMatches", "not-matched");
                        }
                        if (localMap.get("LocalFileMD5").equals(map.get("MD5"))) {
                            map.put("LocalMD5Matches", "matched");
                            break block11;
                        }
                        map.put("LocalMD5Matches", "not-matched");
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                } else {
                    map.put("FileAlias", "");
                }
            }
            map.putAll(new Replicate(rep).asMap());
            JsonObject audit = this.jsonObj.getJsonObject("audit");
            if (audit != null) {
                map.putAll(new Audit(audit, "File").asMap());
            }
            boolean bl = false;
        }
        return map;
    }

    @Override
    public void expand() {
    }
}

