/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.rhwlab.encode.objects.Audit;
import org.rhwlab.encode.objects.EncodeObject;

public class Experiment
extends EncodeObject {
    public Experiment() {
    }

    public Experiment(JsonObject o) {
        this();
        this.jsonObj = o;
    }

    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=Experiment&award.project=modERN&assay_title=total+RNA-seq&assay_title=polyA+depleted+RNA-seq&assay_title=RNA-seq&limit=all&format=json";
    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        JsonValue target = (JsonValue)this.jsonObj.get("target");
        if (target instanceof JsonObject) {
            map.put("ExperimentTarget", ((JsonObject)target).getString("name"));
        } else if (target instanceof JsonString) {
            map.put("ExperimentTarget", ((JsonString)target).getString());
        } else {
            map.put("ExperimentTarget", "");
        }
        String alias = this.getWaterstonAlias();
        map.put("ExperimentAlias", alias);
        map.put("ExperimentReplicates", Integer.toString(this.jsonObj.getJsonArray("replicates").size()));
        map.put("ExperimentFiles", Integer.toString(this.jsonObj.getJsonArray("files").size()));
        map.put("ExperimentAccession", this.jsonObj.getString("accession"));
        map.put("ExperimentStatus", this.jsonObj.getString("status"));
        map.put("ExperimentAssayTitle", this.jsonObj.getString("assay_title"));
        map.put("ExperimentAssayName", this.jsonObj.getString("assay_term_name"));
        map.put("ExperimentDocuments", Integer.toString(this.jsonObj.getJsonArray("documents").size()));
        JsonObject audit = this.jsonObj.getJsonObject("audit");
        if (audit != null) {
            map.putAll(new Audit(audit, "Experiment").asMap());
        }
        return map;
    }

    public String getDbxref() {
        JsonArray xrefs;
        String ret = null;
        JsonObject target = this.jsonObj.getJsonObject("target");
        if (target != null && (xrefs = target.getJsonArray("dbxref")) != null) {
            for (int i = 0; i < xrefs.size(); ++i) {
                String[] tokens = xrefs.getString(i).split(":");
                if (tokens[0].equals("WormBase")) {
                    if (!tokens[1].startsWith("WBGene")) continue;
                    ret = tokens[1];
                    continue;
                }
                if (!tokens[0].equals("FlyBase") || !tokens[1].startsWith("FBgn")) continue;
                ret = tokens[1];
            }
        }
        return ret;
    }

    public String getGeneName() {
        JsonString gene;
        String ret = null;
        JsonObject target = this.jsonObj.getJsonObject("target");
        if (target != null && (gene = target.getJsonString("gene_name")) != null) {
            ret = gene.getString();
        }
        return ret;
    }

    @Override
    public void expand() {
    }
}

