/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.rhwlab.encode.EncodeUrl;

public abstract class EncodeObject {
    JsonObject jsonObj;

    public abstract String getSelectionUrl();

    public abstract void expand();

    public void setJsonObject(JsonObject obj) {
        this.jsonObj = obj;
    }

    public JsonObject getJsonObject() {
        return this.jsonObj;
    }

    public static JsonStructure expand(JsonValue obj, List<String> keys) throws Exception {
        if (obj instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)obj;
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonStructure jsonStruct = EncodeObject.expand((JsonValue)jsonArray.get(i), keys);
                builder.add(jsonStruct);
            }
            return builder.build();
        }
        if (obj instanceof JsonObject) {
            JsonObject jsonObj = (JsonObject)obj;
            if (!keys.isEmpty()) {
                String toExpandKey = keys.get(0);
                JsonValue jsonValue = (JsonValue)jsonObj.get(toExpandKey);
                ArrayList<String> nextKeys = new ArrayList<String>();
                nextKeys.addAll(keys);
                nextKeys.remove(0);
                JsonStructure jsonStruct = EncodeObject.expand(jsonValue, nextKeys);
                JsonObjectBuilder builder = Json.createObjectBuilder();
                for (String key : jsonObj.keySet()) {
                    if (key.equals(toExpandKey)) {
                        builder.add(key, jsonStruct);
                        continue;
                    }
                    builder.add(key, (JsonValue)jsonObj.get(key));
                }
                return builder.build();
            }
            JsonString jsonString = (JsonString)jsonObj.get("@id");
            return EncodeObject.getFromEncode(jsonString.getString());
        }
        if (obj instanceof JsonString) {
            return EncodeObject.getFromEncode(((JsonString)obj).getString());
        }
        return null;
    }

    public void expand(String expand) throws Exception {
        JsonValue toExpand = (JsonValue)this.jsonObj.get(expand);
        if (toExpand instanceof JsonArray) {
            JsonArray expandArray = (JsonArray)toExpand;
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (int i = 0; i < expandArray.size(); ++i) {
                JsonValue arrayValue = (JsonValue)expandArray.get(i);
                if (!(arrayValue instanceof JsonString)) continue;
                JsonObject replacement = EncodeObject.getFromEncode(((JsonString)arrayValue).getString());
                arrayBuilder.add(replacement);
            }
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            for (String key : this.jsonObj.keySet()) {
                if (key.equals(expand)) {
                    objectBuilder.add(expand, arrayBuilder.build());
                    continue;
                }
                objectBuilder.add(key, (JsonValue)this.jsonObj.get(key));
            }
            this.jsonObj = objectBuilder.build();
            boolean bl = false;
        } else if (toExpand instanceof JsonString) {
            JsonObject replacement = EncodeObject.getFromEncode(((JsonString)toExpand).getString());
            this.jsonObj.put(expand, replacement);
        } else if (toExpand instanceof JsonObject) {
            JsonObject replacement = EncodeObject.getFromEncode(((JsonObject)toExpand).getJsonString("@id").getString());
            this.jsonObj.put(expand, replacement);
        }
    }

    public static JsonObject getFromEncode(String id) throws Exception {
        EncodeUrl url = new EncodeUrl(String.format("https://www.encodeproject.org%s", id));
        url.getJson();
        return url.getJsonObject();
    }

    public String getWaterstonAlias() {
        TreeMap<Integer, String> aliasMap = new TreeMap<Integer, String>();
        JsonArray aliases = this.jsonObj.getJsonArray("aliases");
        for (int i = 0; i < aliases.size(); ++i) {
            String alias = aliases.getJsonString(i).getString();
            if (!alias.startsWith("robert-waterston:")) continue;
            String a = alias.replace("robert-waterston:", "");
            String[] tokens = a.split("_");
            aliasMap.put(tokens.length, a);
        }
        if (aliasMap.lastEntry() == null) {
            return null;
        }
        return (String)aliasMap.lastEntry().getValue();
    }

    public abstract TreeMap<String, Object> asMap();
}

