/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.encode.objects.Modification;

public class Donor
extends EncodeObject {
    public Donor() {
    }

    public Donor(JsonObject o) {
        this();
        this.jsonObj = o;
    }

    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=Donor&award=%2Fawards%2FU41HG007355%2F&limit=all&format=json";
    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        JsonArray genMods = this.jsonObj.getJsonArray("genetic_modifications");
        map.put("DonorAccession", this.jsonObj.getString("accession"));
        JsonString genotype = this.jsonObj.getJsonString("genotype");
        if (genotype != null) {
            map.put("DonorGenotype", genotype.toString());
        } else {
            map.put("DonorGenotype", "");
        }
        JsonString strain = this.jsonObj.getJsonString("strain_name");
        if (strain != null) {
            map.put("DonorStrain", strain.getString());
        } else {
            map.put("DonorStrain", "");
        }
        map.put("DonorStatus", this.jsonObj.getString("status"));
        map.put("DonorGeneMods", Integer.toString(genMods.size()));
        if (!genMods.isEmpty() && genMods.get(0) instanceof JsonObject) {
            map.putAll(new Modification(genMods.getJsonObject(0)).asMap());
        }
        return map;
    }

    @Override
    public void expand() {
    }
}

