/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.objects;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.rhwlab.encode.RNASeq.LocalBiosample;
import org.rhwlab.encode.objects.Audit;
import org.rhwlab.encode.objects.Donor;
import org.rhwlab.encode.objects.EncodeObject;

public class Biosample
extends EncodeObject {
    public Biosample() {
    }

    public Biosample(JsonObject o) {
        this();
        this.jsonObj = o;
    }

    @Override
    public String getSelectionUrl() {
        return "https://www.encodeproject.org/search/?type=Biosample&award.project=modERN&limit=all&format=json";
    }

    @Override
    public TreeMap<String, Object> asMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        JsonArray aliases = this.jsonObj.getJsonArray("aliases");
        if (aliases.size() == 0) {
            return map;
        }
        for (int i = 0; i < aliases.size(); ++i) {
            String alias = aliases.getString(i);
            if (!alias.contains("robert-waterston:biosample")) continue;
            map.put("BiosampleAlias", alias.replace("robert-waterston:", ""));
            map.putAll(new Donor(this.jsonObj.getJsonObject("donor")).asMap());
            map.put("BiosampleStatus", this.jsonObj.getString("status"));
            map.put("BiosampleAccession", this.jsonObj.getString("accession"));
            JsonObject audit = this.jsonObj.getJsonObject("audit");
            if (audit != null) {
                map.putAll(new Audit(audit, "Biosample").asMap());
            }
            try {
                LocalBiosample local = new LocalBiosample(alias);
                map.putAll(local.getSummary());
            }
            catch (Exception ex) {
                Logger.getLogger(Biosample.class.getName()).log(Level.SEVERE, null, ex);
            }
            break;
        }
        return map;
    }

    @Override
    public void expand() {
    }
}

