/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.download;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipThread
implements Runnable {
    Map<String, URL> urls;
    PipedOutputStream pipeStream;
    PipedInputStream pipeIn;
    ZipOutputStream zipOut;
    static final int BUFFER = 2048;

    public ZipThread(Map<String, URL> urls) throws Exception {
        this.urls = urls;
        this.pipeStream = new PipedOutputStream();
        this.zipOut = new ZipOutputStream(this.pipeStream);
        this.pipeIn = new PipedInputStream(this.pipeStream);
    }

    @Override
    public void run() {
        try {
            for (String urlName : this.urls.keySet()) {
                this.addUrl(urlName, this.urls.get(urlName));
            }
            this.zipOut.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void addUrl(String urlName, URL url) throws Exception {
        byte[] data = new byte[2048];
        System.out.printf("%s\t%s\n", urlName, url.toExternalForm());
        BufferedInputStream inStream = new BufferedInputStream(url.openStream());
        ZipEntry entry = new ZipEntry(urlName);
        this.zipOut.putNextEntry(entry);
        int n = inStream.read(data, 0, 2048);
        this.zipOut.write(data, 0, n);
        while (n != -1) {
            n = inStream.read(data, 0, 2048);
            if (n <= 0) continue;
            this.zipOut.write(data, 0, n);
        }
        inStream.close();
    }

    public InputStream getStream() {
        return this.pipeIn;
    }

    public void writeTo(final File file) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                byte[] bytes = new byte[1000];
                try {
                    FileOutputStream outStream = new FileOutputStream(file);
                    while (true) {
                        int bytesRead;
                        if ((bytesRead = ZipThread.this.pipeIn.read(bytes, 0, 1000)) == -1) {
                            outStream.close();
                            return;
                        }
                        outStream.write(bytes, 0, bytesRead);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                    return;
                }
            }
        };
        new Thread(runnable).start();
    }
}

