/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.RNASeq;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.rhwlab.encode.objects.Biosample;
import org.rhwlab.encode.objects.Experiment;
import org.rhwlab.encode.objects.FlyDonor;
import org.rhwlab.encode.objects.Library;
import org.rhwlab.encode.objects.Replicate;
import org.rhwlab.encode.objects.Selection;
import org.rhwlab.encode.objects.WormDonor;

public class SummaryFrame
extends JFrame {
    JTabbedPane tabbed;
    File dir = new File("/nfs/waterston/DCCKnockDown");
    TreeMap<String, JTable> tableMap = new TreeMap();

    public SummaryFrame(Set<String> tabs) throws Exception {
        Selection sel;
        String key;
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem saveSel = new JMenuItem("Save selected");
        saveSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                if (chooser.showSaveDialog(SummaryFrame.this.tabbed) == 0) {
                    try {
                        PrintStream stream = new PrintStream(chooser.getSelectedFile());
                        SummaryFrame.this.saveSelected(stream);
                    }
                    catch (FileNotFoundException ex) {
                        Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        fileMenu.add(saveSel);
        JMenu update = new JMenu("Update from DCC");
        fileMenu.add(update);
        JMenuItem expItem = new JMenuItem("Experiments");
        expItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Experiment f = new Experiment();
                    Selection select = new Selection(f.getClass());
                    select.saveToDirectory(SummaryFrame.this.dir);
                    SummaryFrame.this.replaceTab("Experiments", select.toTable());
                }
                catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        JMenuItem filesItem = new JMenuItem("Files");
        filesItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    org.rhwlab.encode.objects.File f = new org.rhwlab.encode.objects.File();
                    Selection select = new Selection(f.getClass());
                    select.saveToDirectory(SummaryFrame.this.dir);
                    SummaryFrame.this.replaceTab("Files", select.toTable());
                }
                catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        JMenuItem repsItem = new JMenuItem("Replicates");
        repsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Replicate f = new Replicate();
                    Selection select = new Selection(f.getClass());
                    select.saveToDirectory(SummaryFrame.this.dir);
                    SummaryFrame.this.replaceTab("Replicates", select.toTable());
                }
                catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        JMenuItem libItem = new JMenuItem("Libraries");
        libItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Library f = new Library();
                    Selection select = new Selection(f.getClass());
                    select.saveToDirectory(SummaryFrame.this.dir);
                    SummaryFrame.this.replaceTab("Libraries", select.toTable());
                }
                catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        JMenuItem sampItem = new JMenuItem("Biosamples");
        sampItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Biosample f = new Biosample();
                    Selection select = new Selection(f.getClass());
                    select.saveToDirectory(SummaryFrame.this.dir);
                    SummaryFrame.this.replaceTab("Biosamples", select.toTable());
                }
                catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        JMenuItem flydonorItem = new JMenuItem("FlyDonors");
        flydonorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FlyDonor f = new FlyDonor();
                    Selection select = new Selection(f.getClass());
                    select.saveToDirectory(SummaryFrame.this.dir);
                    SummaryFrame.this.replaceTab("FlyDonors", select.toTable());
                }
                catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        JMenuItem wormdonorItem = new JMenuItem("WormDonors");
        wormdonorItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    WormDonor f = new WormDonor();
                    Selection select = new Selection(f.getClass());
                    select.saveToDirectory(SummaryFrame.this.dir);
                    SummaryFrame.this.replaceTab("WormDonors", select.toTable());
                }
                catch (Exception ex) {
                    Logger.getLogger(SummaryFrame.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        update.add(expItem);
        update.add(filesItem);
        update.add(repsItem);
        update.add(libItem);
        update.add(sampItem);
        update.add(flydonorItem);
        update.add(wormdonorItem);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        org.rhwlab.encode.objects.File fl = new org.rhwlab.encode.objects.File();
        Replicate rep = new Replicate();
        FlyDonor flydonor = new FlyDonor();
        WormDonor wormdonor = new WormDonor();
        Experiment exp = new Experiment();
        Library lib = new Library();
        Biosample samp = new Biosample();
        this.tabbed = new JTabbedPane();
        if (tabs.contains("Experiments")) {
            key = "experiments";
            sel = new Selection(new File(this.dir, key), exp.getClass());
            this.tabbed.add(key, sel.toTable());
            this.tableMap.put(key, sel.getTable());
        }
        if (tabs.contains("Files")) {
            key = "files";
            sel = new Selection(new File(this.dir, key), fl.getClass());
            this.tabbed.add(key, sel.toTable());
            this.tableMap.put(key, sel.getTable());
        }
        if (tabs.contains("Replicates")) {
            key = "replicates";
            sel = new Selection(new File(this.dir, "replicates"), rep.getClass());
            this.tabbed.add(key, sel.toTable());
            this.tableMap.put(key, sel.getTable());
        }
        if (tabs.contains("Libraries")) {
            key = "libraries";
            sel = new Selection(new File(this.dir, "libraries"), lib.getClass());
            this.tabbed.add(key, sel.toTable());
            this.tableMap.put(key, sel.getTable());
        }
        if (tabs.contains("Biosamples")) {
            key = "biosamples";
            sel = new Selection(new File(this.dir, "biosamples"), samp.getClass());
            this.tabbed.add(key, sel.toTable());
            this.tableMap.put(key, sel.getTable());
        }
        if (tabs.contains("FlyDonors")) {
            key = "fly-donors";
            sel = new Selection(new File(this.dir, "fly-donors"), flydonor.getClass());
            this.tabbed.add(key, sel.toTable());
            this.tableMap.put(key, sel.getTable());
        }
        if (tabs.contains("WormDonors")) {
            key = "worm-donors";
            sel = new Selection(new File(this.dir, "worm-donors"), wormdonor.getClass());
            this.tabbed.add(key, sel.toTable());
            this.tableMap.put(key, sel.getTable());
        }
        this.getContentPane().add(this.tabbed);
        this.pack();
    }

    private void replaceTab(String title, Component c) {
        int i = 0;
        for (int n = this.tabbed.getTabCount(); i < n; ++n) {
            String tab = this.tabbed.getTitleAt(i);
            if (!tab.equals(title)) continue;
            this.tabbed.setComponentAt(i, c);
        }
    }

    private void saveSelected(PrintStream stream) {
        int i;
        String tab = this.tabbed.getTitleAt(this.tabbed.getSelectedIndex());
        JTable selectedTable = this.tableMap.get(tab);
        int[] rows = selectedTable.getSelectedRows();
        int nCols = selectedTable.getColumnCount();
        for (i = 0; i < nCols; ++i) {
            stream.printf("%s\t", selectedTable.getColumnName(i));
        }
        stream.println();
        for (i = 0; i < rows.length; ++i) {
            int r = rows[i];
            for (int c = 0; c < selectedTable.getColumnCount(); ++c) {
                Object obj = selectedTable.getValueAt(r, c);
                stream.printf("%s\t", obj.toString());
            }
            stream.println();
        }
    }

    public static void main(String[] args) throws Exception {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            set.add(args[i]);
        }
        SummaryFrame frame = new SummaryFrame(set);
        frame.setSize(900, 900);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }
}

