/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.RNASeq;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.rhwlab.encode.EncodeUrl;

public class Sample {
    JsonObject json;
    static String searchUrl = "https://www.encodeproject.org/search/?type=File&award.project=modERN&lab.title=Robert+Waterston%2C+UW&limit=all&format=json";

    public Sample(JsonObject obj) {
        this.json = obj;
    }

    public Sample(String accession) throws Exception {
        EncodeUrl url = new EncodeUrl(String.format("https://www.encodeproject.org/biosamples/%s/?format=json", accession));
        url.getJson();
        this.json = url.getJsonObject();
    }

    public JsonObject getJsonObject() {
        return this.json;
    }

    public TreeMap<String, String> getSummary() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        ret.put("SampleAlias", this.json.getJsonArray("aliases").getJsonString(0).getString().replace("robert-waterston:", ""));
        ret.put("SampleAccession", this.json.getString("accession"));
        ret.put("DonorAccession", this.json.getJsonObject("donor").getString("accession"));
        ret.put("DonorStrain", this.json.getJsonObject("donor").getString("strain_name"));
        if (this.json.getJsonObject("donor").getJsonString("genotype") != null) {
            ret.put("DonorGenotype", this.json.getJsonObject("donor").getString("genotype"));
        }
        ret.put("Species", this.getSpecies());
        JsonArray genMods = this.json.getJsonArray("applied_modifications");
        if (genMods != null) {
            for (int i = 0; i < genMods.size(); ++i) {
                JsonObject mod = genMods.getJsonObject(i);
                JsonObject site = mod.getJsonObject("modified_site_by_target_id");
                if (site == null) continue;
                ret.put("GeneticModificationTarget", site.getString("name"));
            }
        }
        return ret;
    }

    public String getSpecies() {
        return this.json.getJsonObject("organism").getString("name");
    }

    public static List<Sample> allBioSamples() {
        ArrayList<Sample> ret = new ArrayList<Sample>();
        return ret;
    }
}

