/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.RNASeq;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import org.rhwlab.json.PrettyWriter;

public class ResponseJsonDCC {
    ArrayList<PrettyWriter> prettyList = new ArrayList();

    public ResponseJsonDCC(String s) {
        BufferedReader bufReader = new BufferedReader(new StringReader(s));
        try {
            String line = bufReader.readLine();
            while (line != null) {
                PrettyWriter pretty = new PrettyWriter();
                pretty.write(line);
                this.prettyList.add(pretty);
                line = bufReader.readLine();
            }
            bufReader.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public Map<String, String> getIdentifiersDCC() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (PrettyWriter pretty : this.prettyList) {
            JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
            for (int i = 0; i < graphArray.size(); ++i) {
                JsonObject respObject = graphArray.getJsonObject(i);
                JsonArray typeArray = respObject.getJsonArray("@type");
                for (int j = 0; j < typeArray.size(); ++j) {
                    String type = typeArray.getJsonString(j).getString().toLowerCase();
                    JsonString jsonAcc = respObject.getJsonString("accession");
                    if (jsonAcc != null) {
                        ret.put(type.toLowerCase(), jsonAcc.getString());
                        continue;
                    }
                    ret.put(type.toLowerCase(), respObject.getJsonString("uuid").getString());
                }
            }
        }
        return ret;
    }

    public Map<String, String> getFileAccessions() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (PrettyWriter pretty : this.prettyList) {
            String n;
            String acc = this.getAccession("file", pretty);
            if (acc.equals("") || (n = this.getPairedEnd(pretty)) == null) continue;
            ret.put(n, acc);
        }
        return ret;
    }

    public String getAccession(String jsonType, PrettyWriter pretty) {
        JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
        for (int i = 0; i < graphArray.size(); ++i) {
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j = 0; j < typeArray.size(); ++j) {
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (!type.equalsIgnoreCase(jsonType)) continue;
                JsonString jsonString = respObject.getJsonString("accession");
                if (jsonString == null) {
                    return "";
                }
                return jsonString.getString();
            }
        }
        return "";
    }

    public Map<String, String> getMD5() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (PrettyWriter pretty : this.prettyList) {
            String n;
            String md5 = this.getMD5("file", pretty);
            if (md5.equals("") || (n = this.getPairedEnd(pretty)) == null) continue;
            ret.put(n, md5);
        }
        return ret;
    }

    public String getMD5(String jsonType, PrettyWriter pretty) {
        JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
        for (int i = 0; i < graphArray.size(); ++i) {
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j = 0; j < typeArray.size(); ++j) {
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (!type.equalsIgnoreCase(jsonType)) continue;
                JsonString jsonString = respObject.getJsonString("md5sum");
                if (jsonString == null) {
                    return "";
                }
                return jsonString.getString();
            }
        }
        return "";
    }

    public String getPairedEnd(PrettyWriter pretty) {
        JsonArray graphArray = pretty.getJson().getJsonArray("@graph");
        for (int i = 0; i < graphArray.size(); ++i) {
            JsonObject respObject = graphArray.getJsonObject(i);
            JsonArray typeArray = respObject.getJsonArray("@type");
            for (int j = 0; j < typeArray.size(); ++j) {
                String type = typeArray.getJsonString(j).getString().toLowerCase();
                if (!type.equalsIgnoreCase("file")) continue;
                return respObject.getJsonString("paired_end").getString();
            }
        }
        return null;
    }
}

