/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.RNASeq;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.TreeMap;
import org.rhwlab.db.MySql;
import org.rhwlab.encode.RNASeq.ResponseJsonDCC;

public class LocalSequencing {
    String seqID;
    String pair;
    String resp;
    String status;

    public LocalSequencing(String aliasDCC) throws Exception {
        int i = aliasDCC.indexOf("_");
        String prefix = aliasDCC.substring(0, i);
        this.seqID = aliasDCC.substring(i + 1);
        this.seqID = this.seqID.replace("BS1", "BS#1");
        this.seqID = this.seqID.replace("BS2", "BS#2");
        if (prefix.startsWith("fastq")) {
            this.pair = prefix.substring(5);
            PreparedStatement state = MySql.getMySql().getStatement("select * from RNASequencing where SequencingID = ?");
            state.setString(1, this.seqID);
            state.execute();
            ResultSet rs = state.getResultSet();
            if (rs.next()) {
                this.resp = rs.getString("ResponseJson");
                state = MySql.getMySql().getStatement("select * from LMSTracking where ID = ? and DBTable = ? and Project = ?");
                state.setString(1, this.seqID);
                state.setString(2, "RNASequencing");
                state.setString(3, "KnockDown");
                state.execute();
                rs = state.getResultSet();
                if (rs.next()) {
                    this.status = rs.getString("Status");
                }
            }
        }
    }

    public TreeMap<String, String> getSummary() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        if (this.status != null) {
            ret.put("LocalSequencingStatus", this.status);
        } else {
            ret.put("LocalSequencingStatus", "");
        }
        if (this.resp == null) {
            ret.put("LocalFileAccession", "");
            ret.put("LocalFileMD5", "");
        } else {
            ResponseJsonDCC dcc = new ResponseJsonDCC(this.resp);
            Map<String, String> accs = dcc.getFileAccessions();
            Map<String, String> md5s = dcc.getMD5();
            ret.put("LocalFileAccession", accs.get(this.pair));
            ret.put("LocalFileMD5", md5s.get(this.pair));
        }
        return ret;
    }
}

