/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.RNASeq;

import java.util.TreeMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.rhwlab.encode.EncodeUrl;
import org.rhwlab.encode.RNASeq.LocalSequencing;
import org.rhwlab.encode.RNASeq.Sample;

public class EncodeFile {
    JsonObject fileJson;
    Sample biosample;
    LocalSequencing localSeq;

    public EncodeFile(JsonObject json) throws Exception {
        this.fileJson = json.getJsonObject("file");
        JsonObject samObj = json.getJsonObject("sample");
        if (samObj != null) {
            this.biosample = new Sample(samObj);
        }
        if (this.getFileFormat().equals("fastq")) {
            this.localSeq = new LocalSequencing(this.getFileAlias());
        }
    }

    public EncodeFile(String accession) throws Exception {
        EncodeUrl url = new EncodeUrl(String.format("https://www.encodeproject.org/files/%s/?format=json", accession));
        url.getJson();
        this.fileJson = url.getJsonObject();
        String sampleAcc = this.getBiosampleAccession();
        if (sampleAcc != null) {
            this.biosample = new Sample(sampleAcc);
        }
        if (this.getFileFormat().equals("fastq")) {
            this.localSeq = new LocalSequencing(this.getFileAlias());
        }
    }

    public JsonObject getJsonObject() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("file", this.fileJson);
        if (this.biosample != null) {
            builder.add("sample", this.biosample.getJsonObject());
        }
        return builder.build();
    }

    public TreeMap<String, String> getSummary() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        ret.put("SubmittedFile", this.fileJson.getString("submitted_file_name"));
        ret.put("FileStatusDCC", this.fileJson.getString("status"));
        ret.put("FileAccession", this.fileJson.getString("accession"));
        ret.put("Format", this.getFileFormat());
        ret.put("MD5", this.fileJson.getString("md5sum"));
        ret.put("BioReplicate", Integer.toString(this.fileJson.getJsonObject("replicate").getInt("biological_replicate_number")));
        ret.put("TechReplicate", Integer.toString(this.fileJson.getJsonObject("replicate").getInt("technical_replicate_number")));
        ret.put("FileAlias", this.getFileAlias());
        ret.put("ReplicateAlias", this.fileJson.getJsonObject("replicate").getJsonArray("aliases").getString(0).replace("robert-waterston:", ""));
        ret.put("LibraryAlias", this.fileJson.getJsonObject("replicate").getJsonObject("library").getJsonArray("aliases").getString(0).replace("robert-waterston:", ""));
        ret.put("LibraryAccession", this.fileJson.getJsonObject("replicate").getJsonObject("library").getJsonString("accession").getString());
        ret.put("ExperimentAccession", this.fileJson.getJsonObject("replicate").getJsonObject("experiment").getJsonString("accession").getString());
        JsonObject targetObj = this.fileJson.getJsonObject("replicate").getJsonObject("experiment").getJsonObject("target");
        if (targetObj != null) {
            ret.put("ExperimentTarget", targetObj.getString("name"));
        } else {
            ret.put("ExperimentTarget", "");
        }
        ret.putAll(this.biosample.getSummary());
        if (this.localSeq != null) {
            ret.putAll(this.localSeq.getSummary());
        }
        return ret;
    }

    public String getFileFormat() {
        return this.fileJson.getString("file_format");
    }

    public String getFileAlias() {
        return this.fileJson.getJsonArray("aliases").getJsonString(0).getString().replace("robert-waterston:", "");
    }

    public String getBiosampleAccession() {
        return this.getBiosampleAccession(this.fileJson);
    }

    public String getBiosampleAccession(JsonObject obj) {
        try {
            return obj.getJsonObject("replicate").getJsonObject("library").getJsonString("biosample").getString().split("/")[2];
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String getSpecies() {
        return this.biosample.getSpecies();
    }
}

