/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq.peaks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.rhwlab.chipseq.ChipSeqBedRecord;
import org.rhwlab.chipseq.Peak;

public class PeakFile {
    Map<String, Peak[]> peakMap = new TreeMap<String, Peak[]>();
    int n = 0;
    String tf;
    String stage = null;

    public PeakFile(File file, String tf, String stage) throws Exception {
        this(file, tf);
        this.stage = stage;
    }

    public PeakFile(File file, String tf) throws Exception {
        this.tf = tf;
        TreeMap<String, List<Peak>> peaks = new TreeMap<String, List<Peak>>();
        GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(file));
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzipStream));
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split("\t");
            int s = Integer.valueOf(tokens[1]);
            int e = Integer.valueOf(tokens[2]);
            short l = (short)(e - s + 1);
            short a = Short.valueOf(tokens[9]);
            Peak peak = new Peak(tf, s, l, a);
            ArrayList<Peak> list = (ArrayList<Peak>)peaks.get(tokens[0]);
            if (list == null) {
                list = new ArrayList<Peak>();
                peaks.put(tokens[0], list);
            }
            list.add(peak);
            ++this.n;
            line = reader.readLine();
        }
        reader.close();
        this.sortPeaks(peaks);
    }

    public PeakFile(List<ChipSeqBedRecord> recs, String tf, String stage) {
        this(recs, tf);
        this.stage = stage;
    }

    public PeakFile(List<ChipSeqBedRecord> recs, String tf) {
        this.tf = tf;
        TreeMap<String, List<Peak>> peaks = new TreeMap<String, List<Peak>>();
        for (ChipSeqBedRecord rec : recs) {
            Peak peak = new Peak(rec);
            ArrayList<Peak> list = (ArrayList<Peak>)peaks.get(rec.getChromosome());
            if (list == null) {
                list = new ArrayList<Peak>();
                peaks.put(rec.getChromosome(), list);
            }
            list.add(peak);
            ++this.n;
        }
        this.sortPeaks(peaks);
    }

    private final void sortPeaks(Map<String, List<Peak>> peaks) {
        for (String chr : peaks.keySet()) {
            List<Peak> list = peaks.get(chr);
            Object[] peakArray = list.toArray(new Peak[0]);
            Arrays.sort(peakArray);
            this.peakMap.put(chr, (Peak[])peakArray);
        }
    }

    public Peak[] getChromosomePeaks(String chromo) {
        return this.peakMap.get(chromo);
    }

    public int getRecordCount() {
        return this.n;
    }

    public String getTF() {
        return this.tf;
    }

    public Set<String> getChromosomes() {
        return this.peakMap.keySet();
    }

    public static void main(String[] args) throws Exception {
        PeakFile peakFile = new PeakFile(new File("/net/waterston/vol2/home/gevirl/Downloads/worm/ce11/ENCFF998SQM_spp.optimal.ZTF-11_OP236_WA_Em_IP_Rep0.tagAlign_VS_ZTF-11_OP236_WA_Em_Input_Rep0.tagAlign.regionPeak.gz"), "ZTF-11");
    }
}

