/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq.peaks;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalTree;
import htsjdk.samtools.util.IntervalTreeMap;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.UCSC.AggregateBed;
import org.rhwlab.chipseq.ChipSeqBedRecord;
import org.rhwlab.chipseq.Peak;
import org.rhwlab.chipseq.PeakCluster;
import org.rhwlab.encode.ChipSeq.IndexedSelection;
import org.rhwlab.encode.ChipSeq.ReleasedWormSelection;
import org.rhwlab.encode.ChipSeq.ViewByTF;
import org.rhwlab.encode.ChipSeq.peaks.PeakFile;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.gene.model.Annotation;
import org.rhwlab.gene.model.AnnotationModel;
import org.rhwlab.gene.model.ModelFromGFF;
import org.rhwlab.modern.DCCFile;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.ExperimentalFile;
import org.rhwlab.modern.ReferenceGenome;

public class PeakClusters {
    File dir;
    int n;
    Map<String, List<PeakCluster>> clusterMap = new TreeMap<String, List<PeakCluster>>();
    TreeSet<String> tfs = new TreeSet();

    public PeakClusters(String assembly, IndexedSelection expSelect, Set<String> stages, int delta) throws Exception {
        ArrayList<PeakFile> peakFiles = new ArrayList<PeakFile>();
        for (String tf : expSelect.getAllTFs()) {
            TreeMap<String, String[]> accMap = expSelect.getAccessionsForTF(tf);
            for (String stage : accMap.keySet()) {
                if (stages == null || stages.contains(stage)) {
                    String[] accs;
                    for (String acc : accs = accMap.get(stage)) {
                        EncodeObject obj = expSelect.getEncodeObject(acc);
                        Experiment modExp = new Experiment(obj.getJsonObject());
                        for (DCCFile dccFile : modExp.getFiles()) {
                            if (!dccFile.getStatus().equals("released") || dccFile.getAssembly() == null || !dccFile.getAssembly().equals(assembly)) continue;
                            ArrayList<ChipSeqBedRecord> bedRecords = new ArrayList<ChipSeqBedRecord>();
                            String fname = dccFile.getSubmittedFileName();
                            if (!fname.startsWith("spp.optimal") || !fname.endsWith(".gz")) continue;
                            ExperimentalFile expFile = new ExperimentalFile(dccFile, null);
                            URL url = new URL(expFile.getDownloadLink());
                            AggregateBed.readBedRecords(tf, stage, url, bedRecords);
                            PeakFile peakFile = new PeakFile(bedRecords, tf, stage);
                            peakFiles.add(peakFile);
                            this.tfs.add(peakFile.getTF());
                        }
                    }
                }
                boolean bl = false;
            }
        }
        this.clusterThePeaks(peakFiles, delta);
    }

    public PeakClusters(File dir, int delta) throws Exception {
        ArrayList<PeakFile> peakFiles = new ArrayList<PeakFile>();
        this.dir = dir;
        int nFiles = 0;
        for (File file : dir.listFiles()) {
            if (!file.getName().endsWith(".gz")) continue;
            ++nFiles;
            String s = file.getName().split("_")[1];
            String tf = s.replace("spp.optimal.", "");
            PeakFile peakFile = new PeakFile(file, tf);
            peakFiles.add(peakFile);
            this.n += peakFile.getRecordCount();
            this.tfs.add(tf);
        }
        System.out.printf("Total peaks: %s,  total files: %d\n", this.n, nFiles);
        this.clusterThePeaks(peakFiles, delta);
    }

    public PeakClusters(List<PeakFile> peakFiles, int delta) {
        int n = 0;
        for (PeakFile peakFile : peakFiles) {
            this.tfs.add(peakFile.getTF());
            n += peakFile.getRecordCount();
        }
        this.clusterThePeaks(peakFiles, delta);
    }

    public final void clusterThePeaks(List<PeakFile> peakFiles, int delta) {
        TreeSet<String> chromoSet = new TreeSet<String>();
        for (PeakFile peakFile : peakFiles) {
            chromoSet.addAll(peakFile.getChromosomes());
        }
        for (String chromo : chromoSet) {
            this.clusterMap.put(chromo, this.clusterChromo(chromo, peakFiles, delta));
        }
    }

    private List<PeakCluster> clusterChromo(String chromo, List<PeakFile> peakFiles, int delta) {
        List<Peak> chromPeaks = this.aggregatePeaks(chromo, peakFiles);
        System.out.printf("%s peaks: %s\n", chromo, chromPeaks.size());
        ArrayList<PeakCluster> ret = new ArrayList<PeakCluster>();
        PeakCluster cluster = new PeakCluster(chromo);
        Peak currentPeak = chromPeaks.get(0);
        cluster.addPeak(currentPeak);
        for (int i = 1; i < chromPeaks.size(); ++i) {
            Peak next = chromPeaks.get(i);
            if (currentPeak.distanceTo(next) > delta) {
                ret.add(cluster);
                cluster = new PeakCluster(chromo);
            }
            cluster.addPeak(next);
            currentPeak = next;
        }
        return ret;
    }

    private List<Peak> aggregatePeaks(String chromo, List<PeakFile> peakFiles) {
        ArrayList<Peak> ret = new ArrayList<Peak>();
        ArrayList<Peak[]> peakArraysList = new ArrayList<Peak[]>();
        for (PeakFile peakFile : peakFiles) {
            Peak[] peaks = peakFile.getChromosomePeaks(chromo);
            if (peaks == null) continue;
            peakArraysList.add(peaks);
        }
        Peak[] currentPeak = new Peak[peakArraysList.size()];
        int[] pos = new int[peakArraysList.size()];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = 0;
            Peak[] peaks = (Peak[])peakArraysList.get(i);
            currentPeak[i] = ((Peak[])peakArraysList.get(i))[0];
        }
        int m = this.minPeak(currentPeak);
        while (m != -1) {
            ret.add(currentPeak[m]);
            int next = pos[m] + 1;
            Peak[] peaks = (Peak[])peakArraysList.get(m);
            if (next < peaks.length) {
                currentPeak[m] = peaks[next];
                pos[m] = next;
            } else {
                pos[m] = -1;
                currentPeak[m] = null;
            }
            m = this.minPeak(currentPeak);
        }
        return ret;
    }

    public void report(File file) throws Exception {
        PrintStream stream = new PrintStream(file);
        PeakCluster.reportHeader(stream, this.tfs, "\t");
        for (String chromo : this.clusterMap.keySet()) {
            for (PeakCluster cluster : this.clusterMap.get(chromo)) {
                cluster.report(stream, this.tfs, "\t");
            }
        }
        stream.close();
    }

    private int minPeak(Peak[] peaks) {
        int i;
        int ret = -1;
        for (i = 0; i < peaks.length; ++i) {
            if (peaks[i] == null) continue;
            ret = i;
            break;
        }
        if (ret != -1) {
            for (i = ret + 1; i < peaks.length; ++i) {
                if (peaks[i] == null || peaks[ret].compareTo(peaks[i]) <= 0) continue;
                ret = i;
            }
        }
        return ret;
    }

    public void locateInGenome(AnnotationModel annotModel) {
        for (String chromo : this.clusterMap.keySet()) {
            List<PeakCluster> peakClusterList = this.clusterMap.get(chromo);
            IntervalTreeMap geneIntervalMap = annotModel.asTree("gene", chromo, "biotype=protein_coding");
            IntervalTree geneIntervalTree = new IntervalTree();
            for (Object obj : geneIntervalMap.keySet()) {
                Interval geneInterval = (Interval)obj;
                Object geneAnnot = geneIntervalMap.get(geneInterval);
                boolean bl = geneAnnot instanceof List ? false : false;
                geneIntervalTree.put(geneInterval.getStart(), geneInterval.getEnd(), geneAnnot);
            }
            for (PeakCluster cluster : peakClusterList) {
                String[] names;
                ModelFromGFF gff;
                List<Annotation> annots;
                cluster.locateInGenome(geneIntervalMap, geneIntervalTree);
                String targetGene = cluster.getTarget();
                if (annotModel instanceof ModelFromGFF && !(annots = (gff = (ModelFromGFF)annotModel).getTranscriptsForGene((names = gff.geneNameTriplet(targetGene))[2])).isEmpty()) {
                    int i;
                    Annotation annot = annots.get(0);
                    String targetStrand = annot.getStrand();
                    if (targetStrand.equals("+")) {
                        for (i = 0; i < annots.size(); ++i) {
                            if (cluster.getMeanPosition() >= annot.getStart()) continue;
                            cluster.setTranscript(annot.getTranscript());
                            break;
                        }
                    } else {
                        for (i = annots.size() - 1; i >= 0; --i) {
                            if (cluster.getMeanPosition() <= annot.getEnd()) continue;
                            cluster.setTranscript(annot.getTranscript());
                            break;
                        }
                    }
                }
                boolean bl = false;
            }
        }
    }

    public void toBedFormat(String bedFile) throws Exception {
        PrintStream stream = new PrintStream(bedFile);
        for (String chromo : this.clusterMap.keySet()) {
            for (PeakCluster cluster : this.clusterMap.get(chromo)) {
                cluster.reportAsBedFormat(stream);
            }
        }
        stream.close();
    }

    public static void main(String[] args) throws Exception {
        ModelFromGFF gff3 = new ModelFromGFF(new File("/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3"));
        TreeSet<String> embryonicStages = new TreeSet<String>(Arrays.asList("earlyembryonic", "lateembryonic", "midembryonic", "mixedstage(embryonic)"));
        TreeSet<String> earlyLarvalStages = new TreeSet<String>(Arrays.asList("L1larva", "L2larva", "L3larva"));
        TreeSet<String> embryonicLarvalStages = new TreeSet<String>();
        embryonicLarvalStages.addAll(embryonicStages);
        embryonicLarvalStages.addAll(earlyLarvalStages);
        ReleasedWormSelection selection = new ReleasedWormSelection(new File(args[0]));
        ReferenceGenome genome = new ReferenceGenome();
        ViewByTF view = new ViewByTF();
        view.setGenomes(genome);
        view.setSpecies("worm");
        view.setSelection(selection);
        genome.setAssembly("worm", "ce11");
        AggregateBed aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz", embryonicStages);
        PeakClusters clusters = new PeakClusters("ce11", selection, embryonicStages, 60);
        String bedFile = "/net/waterston/vol2/home/gevirl/EmbryonicPeakClusters.bed";
        String aggBedFile = "/net/waterston/vol2/home/gevirl/EmbryonicPeak.bed";
        String reportFile = "/net/waterston/vol2/home/gevirl/EmbryonicPeakClusters.tab";
        clusters.locateInGenome(gff3);
        clusters.report(new File(reportFile));
        clusters.toBedFormat(bedFile);
        aggBed.writeTo(new File(aggBedFile));
        aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz", embryonicLarvalStages);
        clusters = new PeakClusters("ce11", selection, embryonicLarvalStages, 60);
        bedFile = "/net/waterston/vol2/home/gevirl/Embryonic_LarvalPeakClusters.bed";
        aggBedFile = "/net/waterston/vol2/home/gevirl/Embryonic_LarvalPeak.bed";
        reportFile = "/net/waterston/vol2/home/gevirl/Embryonic_LarvalPeakClusters.tab";
        clusters.locateInGenome(gff3);
        clusters.report(new File(reportFile));
        clusters.toBedFormat(bedFile);
        aggBed.writeTo(new File(aggBedFile));
        aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz", earlyLarvalStages);
        clusters = new PeakClusters("ce11", selection, earlyLarvalStages, 60);
        bedFile = "/net/waterston/vol2/home/gevirl/EarlyLarvalPeakClusters.bed";
        aggBedFile = "/net/waterston/vol2/home/gevirl/EarlyLarvalPeak.bed";
        reportFile = "/net/waterston/vol2/home/gevirl/EarlyLarvalPeakClusters.tab";
        clusters.locateInGenome(gff3);
        clusters.report(new File(reportFile));
        clusters.toBedFormat(bedFile);
        aggBed.writeTo(new File(aggBedFile));
        aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz", null);
        clusters = new PeakClusters("ce11", selection, null, 60);
        bedFile = "/net/waterston/vol2/home/gevirl/PeakClusters.bed";
        bedFile = "/net/waterston/vol2/home/gevirl/Peak.bed";
        reportFile = "/net/waterston/vol2/home/gevirl/PeakClusters.tab";
        clusters.locateInGenome(gff3);
        clusters.report(new File(reportFile));
        clusters.toBedFormat(bedFile);
        aggBed.writeTo(new File(aggBedFile));
        boolean dfhuhf = false;
    }
}

