/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq.peaks;

import com.apporiented.algorithm.clustering.AverageLinkageStrategy;
import com.apporiented.algorithm.clustering.Cluster;
import com.apporiented.algorithm.clustering.DefaultClusteringAlgorithm;
import com.apporiented.algorithm.clustering.LinkageStrategy;
import com.apporiented.algorithm.clustering.visualization.DendrogramPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.rhwlab.encode.ChipSeq.peaks.ClusterEnrichment;
import org.rhwlab.heatmap.MappableHeatMap;
import org.rhwlab.heatmap.SaveableFrame;
import org.rhwlab.imaging.binarytree.Gradient;

public class EnrichmentHeatmap {
    public static void main(String[] args) throws Exception {
        double minP = 0.01;
        double thresh = -Math.log10(minP);
        TreeMap<String, List<ClusterEnrichment>> map = ClusterEnrichment.readFiles("/net/waterston/vol2/home/gevirl/FACS/enrichment/gene", "geneEnrich");
        TreeMap<Object, TreeMap<String, ClusterEnrichment>> byTF = new TreeMap<Object, TreeMap<String, ClusterEnrichment>>();
        for (String string : map.keySet()) {
            for (ClusterEnrichment enrich : map.get(string)) {
                String tf = enrich.tf;
                TreeMap<String, ClusterEnrichment> byFile = (TreeMap<String, ClusterEnrichment>)byTF.get(tf);
                if (byFile == null) {
                    byFile = new TreeMap<String, ClusterEnrichment>();
                    byTF.put(tf, byFile);
                }
                byFile.put(string, enrich);
            }
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String tf : byTF.keySet()) {
            if (tf.equals("ceh-22")) {
                boolean enrich = false;
            }
            boolean keep = false;
            for (Object enrich : ((TreeMap)byTF.get(tf)).values()) {
                if (!(((ClusterEnrichment)enrich).pVal < minP)) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            toRemove.add(tf);
        }
        for (String tf : toRemove) {
            byTF.remove(tf);
        }
        int n = byTF.size();
        String[] tfNames = byTF.keySet().toArray(new String[0]);
        double[][] m = new double[n][];
        int row = 0;
        for (String tf : byTF.keySet()) {
            TreeMap byFile = (TreeMap)byTF.get(tf);
            m[row] = new double[byFile.size()];
            int col = 0;
            for (String fileName : byFile.keySet()) {
                m[row][col] = ((ClusterEnrichment)byFile.get((Object)fileName)).logP;
                ++col;
            }
            ++row;
        }
        EuclideanDistance dist = new EuclideanDistance();
        double[][] d = new double[n][];
        for (int i = 0; i < d.length; ++i) {
            d[i] = new double[n];
            d[i][i] = 0.0;
        }
        for (int r = 0; r < n; ++r) {
            for (int c = r + 1; c < n; ++c) {
                double ed;
                d[r][c] = ed = dist.compute(m[r], m[c]);
                d[c][r] = ed;
            }
        }
        DefaultClusteringAlgorithm alg = new DefaultClusteringAlgorithm();
        Cluster cluster = alg.performClustering((double[][])d, tfNames, (LinkageStrategy)new AverageLinkageStrategy());
        List leaves = cluster.getLeafNames();
        double largest = 0.0;
        double smallest = 0.0;
        Object z = new double[m.length][];
        for (int i = 0; i < leaves.size(); ++i) {
            TreeMap byFile = (TreeMap)byTF.get(leaves.get(i));
            z[i] = new double[byFile.size()];
            int j = 0;
            for (String fileName : byFile.keySet()) {
                z[i][j] = ((ClusterEnrichment)byFile.get((Object)fileName)).logP;
                if (z[i][j] < smallest) {
                    smallest = z[i][j];
                }
                if (z[i][j] > largest) {
                    largest = z[i][j];
                }
                ++j;
            }
        }
        double[][] x = new double[1][];
        int nn = (int)(largest - smallest);
        x[0] = new double[nn];
        for (int i = 0; i < nn; ++i) {
            x[0][i] = largest - (double)i;
            if (!(x[0][i] < 0.0)) continue;
            double[] dArray = x[0];
            int n2 = i;
            dArray[n2] = dArray[n2] - 1.0;
        }
        TreeMap<Double, String> scaleLabels = new TreeMap<Double, String>();
        for (int i = 0; i < nn; ++i) {
            int v = (int)x[0][i];
            if (Math.abs(v) % 10 != 0) continue;
            scaleLabels.put(Double.valueOf(i), Integer.toString(v));
        }
        double pos = 0.5;
        TreeMap<Double, String> yLabels = new TreeMap<Double, String>();
        for (int i = 0; i < ((double[][])z).length; ++i) {
            if (i % 2 != 0) {
                System.out.println((String)leaves.get(i));
            }
            yLabels.put(pos, (String)leaves.get(i));
            pos += 1.0;
        }
        String[] seriesNames = new String[]{"ceh-32", "cnd-1", "end-1", "hlh-1", "nhr-25", "pha-4", "tbx-37"};
        double r = 0.5;
        double s = 2.5;
        TreeMap<Double, String> xLabels = new TreeMap<Double, String>();
        TreeMap<Double, String> seriesLabels = new TreeMap<Double, String>();
        for (int i = 0; i < 7; ++i) {
            String series = seriesNames[i];
            seriesLabels.put(s, series);
            for (int j = 0; j < 5; ++j) {
                xLabels.put(r, String.format("T%d", j));
                r += 1.0;
            }
            s += 5.0;
        }
        z = new Array2DRowRealMatrix((double[][])z).transpose().getData();
        Color[][] gradients = new Color[3][];
        Color[] negColors = new Color[]{Color.MAGENTA, new Color(125, 0, 125), new Color(0, 0, 255, 100)};
        gradients[0] = Gradient.createMultiGradient(negColors, 100);
        gradients[1] = new Color[1];
        gradients[1][0] = Color.LIGHT_GRAY;
        Color[] posColors = new Color[]{new Color(0, 255, 0, 50), new Color(0, 255, 0), new Color(255, 255, 0, 100), new Color(255, 255, 0, 150), new Color(255, 255, 0)};
        gradients[2] = Gradient.createMultiGradient(posColors, 100);
        double[] bounds = new double[]{-thresh, thresh};
        MappableHeatMap zheatMap = new MappableHeatMap((double[][])z, true, gradients, bounds);
        zheatMap.setDrawYTicks(true);
        zheatMap.setYLabels(yLabels);
        zheatMap.setDrawXTicks(true);
        zheatMap.setXLabels(xLabels);
        zheatMap.setXLabels(seriesLabels);
        zheatMap.setPreferredSize(new Dimension(600, 1500));
        MappableHeatMap xheatMap = new MappableHeatMap(x, true, gradients, bounds);
        xheatMap.setDrawYTicks(true);
        xheatMap.setYLabels(scaleLabels);
        SaveableFrame xheatChartFrame = new SaveableFrame();
        xheatChartFrame.setContentPane(xheatMap);
        xheatChartFrame.setSize(200, 700);
        xheatChartFrame.setVisible(true);
        SaveableFrame zheatChartFrame = new SaveableFrame();
        zheatChartFrame.setTitle("Both");
        zheatChartFrame.setContentPane(zheatMap);
        zheatChartFrame.pack();
        zheatChartFrame.setSize(1000, 1100);
        zheatChartFrame.setVisible(true);
        zheatChartFrame.setDefaultCloseOperation(2);
        DendrogramPanel dp = new DendrogramPanel();
        dp.setModel(cluster);
        dp.setPreferredSize(new Dimension(1000, 1500));
        JFrame frame = new JFrame();
        JScrollPane scroll = new JScrollPane((Component)dp);
        frame.setContentPane(scroll);
        frame.pack();
        frame.setSize(1000, 1200);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        boolean asdhfuishd = false;
    }
}

