/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq.peaks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.chipseq.PeakCluster;
import org.rhwlab.tfs.AllTFs;

public class ClusterReportFile {
    File tsv;
    List<PeakCluster> clusters;

    public ClusterReportFile(File tsv) throws Exception {
        this(tsv, Integer.MAX_VALUE, null);
    }

    public ClusterReportFile(File tsv, AllTFs all) throws Exception {
        this(tsv, Integer.MAX_VALUE, all);
    }

    public ClusterReportFile(File tsv, int max, AllTFs all) throws Exception {
        this.tsv = tsv;
        this.clusters = new ArrayList<PeakCluster>();
        BufferedReader reader = new BufferedReader(new FileReader(tsv));
        String[] heads = reader.readLine().split("\t");
        String line = reader.readLine();
        while (line != null) {
            PeakCluster cluster = new PeakCluster(heads, line.split("\t"), all);
            if (cluster.getTFs().size() <= max) {
                this.clusters.add(cluster);
            }
            line = reader.readLine();
        }
        reader.close();
    }

    public TreeMap<String, TreeMap<Integer, PeakCluster>> peaksByPosition(int min, int max) {
        TreeMap<String, TreeMap<Integer, PeakCluster>> ret = new TreeMap<String, TreeMap<Integer, PeakCluster>>();
        for (PeakCluster cluster : this.clusters) {
            int n = cluster.getTFs().size();
            if (min > n || n > max) continue;
            TreeMap<Integer, PeakCluster> chrMap = ret.get(cluster.getChromosome());
            if (chrMap == null) {
                chrMap = new TreeMap();
                ret.put(cluster.getChromosome(), chrMap);
            }
            n = cluster.getMeanPosition();
            chrMap.put(n, cluster);
        }
        return ret;
    }

    public TreeMap<String, List<PeakCluster>> allIndexedClusters(int min, int max) throws Exception {
        TreeMap<String, List<PeakCluster>> ret = new TreeMap<String, List<PeakCluster>>();
        for (PeakCluster cluster : this.getAllPeakClusters(min, max)) {
            String target = cluster.getTarget();
            List<PeakCluster> list = ret.get(target);
            if (list == null) {
                list = new ArrayList<PeakCluster>();
                ret.put(target, list);
            }
            list.add(cluster);
        }
        return ret;
    }

    public TreeMap<String, List<PeakCluster>> allIndexedClusters(int limit) throws Exception {
        TreeMap<String, List<PeakCluster>> ret = new TreeMap<String, List<PeakCluster>>();
        for (PeakCluster cluster : this.getAllPeakClusters(limit)) {
            String target = cluster.getTarget();
            List<PeakCluster> list = ret.get(target);
            if (list == null) {
                list = new ArrayList<PeakCluster>();
                ret.put(target, list);
            }
            list.add(cluster);
        }
        return ret;
    }

    public TreeSet<String> getClusterTargets() throws Exception {
        TreeSet<String> ret = new TreeSet<String>();
        if (this.clusters == null) {
            this.clusters = this.getAllPeakClusters(Integer.MAX_VALUE);
        }
        for (PeakCluster cluster : this.clusters) {
            ret.add(cluster.getTarget());
        }
        return ret;
    }

    public int[] distributionOfClusterSizes() throws Exception {
        int maxN = 0;
        TreeMap<Integer, Integer> countsMap = new TreeMap<Integer, Integer>();
        for (PeakCluster cluster : this.getAllPeakClusters(Integer.MAX_VALUE)) {
            int n = cluster.getTFs().size();
            Integer count = (Integer)countsMap.get(n);
            if (count == null) {
                countsMap.put(n, 1);
            } else {
                countsMap.put(n, count + 1);
            }
            if (n <= maxN) continue;
            maxN = n;
        }
        int[] ret = new int[maxN + 1];
        for (int i = 0; i < maxN; ++i) {
            Integer count = (Integer)countsMap.get(i);
            ret[i] = count == null ? 0 : count;
        }
        return ret;
    }

    public List<PeakCluster> getAllPeakClusters(int min, int max) {
        ArrayList<PeakCluster> ret = new ArrayList<PeakCluster>();
        for (PeakCluster cluster : this.clusters) {
            int n = cluster.getTFs().size();
            if (min > n || n > max) continue;
            ret.add(cluster);
        }
        return ret;
    }

    public List<PeakCluster> getAllPeakClusters(int maxSizeCluster) throws Exception {
        ArrayList<PeakCluster> ret = new ArrayList<PeakCluster>();
        for (PeakCluster cluster : this.clusters) {
            if (cluster.getTFs().size() > maxSizeCluster) continue;
            ret.add(cluster);
        }
        return ret;
    }

    public List<PeakCluster> getClustersOnChromosome(String chr) throws Exception {
        return this.getClustersMeanWithin(chr, 0, Integer.MAX_VALUE);
    }

    public List<PeakCluster> getClustersForTarget(String target) throws Exception {
        ArrayList<PeakCluster> ret = new ArrayList<PeakCluster>();
        for (PeakCluster cluster : this.clusters) {
            if (!cluster.getTarget().equals(target)) continue;
            ret.add(cluster);
        }
        return ret;
    }

    public List<PeakCluster> getClustersWithAll(String[] tfs) throws Exception {
        ArrayList<PeakCluster> ret = new ArrayList<PeakCluster>();
        for (PeakCluster cluster : this.clusters) {
            boolean found = true;
            for (String tf : tfs) {
                if (cluster.containsTF(tf)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            ret.add(cluster);
        }
        return ret;
    }

    public List<PeakCluster> getClustersMeanWithin(String chr, int low, int high) throws Exception {
        ArrayList<PeakCluster> ret = new ArrayList<PeakCluster>();
        for (PeakCluster cluster : this.clusters) {
            if (!cluster.getChromosome().equals(chr) || cluster.getMeanPosition() < low || cluster.getMeanPosition() > high) continue;
            ret.add(cluster);
        }
        return ret;
    }

    public PeakCluster getClusterAt(String chr, int pos) throws Exception {
        for (PeakCluster cluster : this.clusters) {
            if (!cluster.getChromosome().equals(chr) || cluster.getMeanPosition() != pos) continue;
            return cluster;
        }
        return null;
    }

    public Set<String> getChipedTFs() throws Exception {
        TreeSet<String> ret = new TreeSet<String>();
        for (PeakCluster cluster : this.clusters) {
            ret.addAll(cluster.getTFs());
        }
        return ret;
    }

    public int clusterEnrichment(Set<String> targetGenes, TreeMap<String, Integer> map, int limit) throws Exception {
        int N = 0;
        for (PeakCluster cluster : this.getAllPeakClusters(limit)) {
            String peakTarget = cluster.possibleTarget();
            if (!targetGenes.isEmpty() && !targetGenes.contains(peakTarget)) continue;
            ++N;
            for (String tf : cluster.getTFs()) {
                Integer k = map.get(tf);
                k = k == null ? Integer.valueOf(1) : Integer.valueOf(k + 1);
                map.put(tf, k);
            }
        }
        return N;
    }

    public int geneEnrichment(Set<String> targetGenes, TreeMap<String, List<PeakCluster>> clusterMap, TreeMap<String, Integer> map, int limit) throws Exception {
        int N = 0;
        for (String target : clusterMap.keySet()) {
            if (!targetGenes.contains(target)) continue;
            ++N;
            TreeSet<String> tfs = new TreeSet<String>();
            for (PeakCluster cluster : clusterMap.get(target)) {
                for (String tf : cluster.getTFs()) {
                    tfs.add(tf);
                }
            }
            for (String tf : tfs) {
                Integer n = map.get(tf);
                if (n == null) {
                    map.put(tf, 1);
                    continue;
                }
                map.put(tf, n + 1);
            }
        }
        return N;
    }

    public static void main(String[] args) throws Exception {
        ClusterReportFile file = new ClusterReportFile(new File("/net/waterston/vol2/home/gevirl/Embryonic_LarvalPeakClusters.tab"));
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        int n = file.clusterEnrichment(new TreeSet<String>(), map, 50);
        Set<String> chippedTFs = file.getChipedTFs();
        String[] tfs = new String[]{"egl-5", "lin-39", "mab-5", "rnt-1"};
        List<PeakCluster> list = file.getClustersWithAll(tfs);
        TreeSet<String> targets = new TreeSet<String>();
        for (PeakCluster cluster : list) {
            targets.add(cluster.possibleTarget());
        }
        boolean uiasdfuhs = false;
    }
}

