/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq.peaks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.chipseq.PeakCluster;
import org.rhwlab.encode.ChipSeq.peaks.ClusterReportFile;
import org.rhwlab.encode.ChipSeq.peaks.DEGenes;
import umontreal.iro.lecuyer.probdist.BinomialDist;

public class ClusterEnrichment
implements Comparable {
    String tf;
    int occupiedClusters;
    int totalClusters;
    double ratio;
    int tfClusters;
    double genomeRatio;
    double pVal;
    String sign;
    int N;
    double logP;

    public ClusterEnrichment(String tf, int occupiedClusters, int totalClusters, double ratio, int tfClusters, int N, double genomeRatio, double pVal, String sign) {
        this.tf = tf;
        this.occupiedClusters = occupiedClusters;
        this.pVal = pVal;
        this.genomeRatio = genomeRatio;
        this.sign = sign;
        this.totalClusters = totalClusters;
        this.ratio = ratio;
        this.tfClusters = tfClusters;
        this.N = N;
        if (pVal > 0.0) {
            this.logP = Math.log10(pVal);
        }
        if (sign.equals("+")) {
            this.logP = -this.logP;
        }
    }

    public static TreeMap<String, List<ClusterEnrichment>> readFiles(String directory, String contains) throws Exception {
        TreeMap<String, List<ClusterEnrichment>> ret = new TreeMap<String, List<ClusterEnrichment>>();
        for (File file : new File(directory).listFiles()) {
            if (!file.getName().contains(contains)) continue;
            ArrayList<ClusterEnrichment> list = new ArrayList<ClusterEnrichment>();
            ret.put(file.getName(), list);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                String[] tokens = line.split(",");
                list.add(new ClusterEnrichment(tokens[0], Integer.valueOf(tokens[1]), Integer.valueOf(tokens[2]), Double.valueOf(tokens[3]), Integer.valueOf(tokens[4]), Integer.valueOf(tokens[5]), Double.valueOf(tokens[6]), Double.valueOf(tokens[7]), tokens[8]));
                line = reader.readLine();
            }
            reader.close();
        }
        return ret;
    }

    public void print(PrintStream stream) {
        stream.printf("%s,%d,%d,%f,%d,%d,%f,%e,%s,%f\n", this.tf, this.occupiedClusters, this.totalClusters, this.ratio, this.tfClusters, this.N, this.genomeRatio, this.pVal, this.sign, this.logP);
    }

    public int compareTo(Object o) {
        ClusterEnrichment other = (ClusterEnrichment)o;
        int ret = Double.compare(other.logP, this.logP);
        if (ret == 0) {
            ret = this.tf.compareTo(other.tf);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int maxClusterTFs = 50;
        File dir = new File("/net/waterston/vol2/home/gevirl/FACS/enrichment");
        ClusterReportFile file = new ClusterReportFile(new File("/net/waterston/vol2/home/gevirl/Embryonic_LarvalPeakClusters.tab"));
        Set<String> chippedTFs = file.getChipedTFs();
        DEGenes de = new DEGenes(new File("/net/waterston/vol2/home/gevirl/Downloads/gene_diffexpress.yes_exclude.180130.txt"));
        String[] times = new String[]{"T0", "T1", "T2", "T3", "T4"};
        String[] tissues = new String[]{"ceh32", "cnd1", "end1", "hlh1", "nhr25", "pha4", "tbx37"};
        TreeMap<String, List<PeakCluster>> allClusterMap = file.allIndexedClusters(maxClusterTFs);
        TreeMap<String, Integer> allTargetEnrich = new TreeMap<String, Integer>();
        int geneN = file.geneEnrichment(allClusterMap.keySet(), allClusterMap, allTargetEnrich, maxClusterTFs);
        TreeMap<String, Double> binP = new TreeMap<String, Double>();
        for (String tf : allTargetEnrich.keySet()) {
            double p = (double)allTargetEnrich.get(tf).intValue() / (double)geneN;
            binP.put(tf, p);
        }
        for (String tissue : tissues) {
            for (String time : times) {
                System.out.printf("%s    %s\n", tissue, time);
                File outFile = new File(dir, String.format("%s_%s_geneEnrich_%d.csv", tissue, time, maxClusterTFs));
                PrintStream stream = new PrintStream(outFile);
                TreeMap<String, Integer> geneEnrich = new TreeMap<String, Integer>();
                Set<String> genes = de.getGenes(tissue, time, 0.05);
                int n = file.geneEnrichment(genes, allClusterMap, geneEnrich, maxClusterTFs);
                TreeSet<ClusterEnrichment> sort = new TreeSet<ClusterEnrichment>();
                for (String tf : allTargetEnrich.keySet()) {
                    BinomialDist dist = new BinomialDist(n, ((Double)binP.get(tf)).doubleValue());
                    Integer enrich = geneEnrich.get(tf);
                    if (enrich == null) {
                        enrich = 0;
                    }
                    double ratio = (double)enrich.intValue() / (double)n;
                    double pVal = (Double)binP.get(tf) < ratio ? dist.barF(enrich.intValue()) : dist.cdf(enrich.intValue());
                    String sign = "+";
                    if ((Double)binP.get(tf) > ratio) {
                        sign = "-";
                    }
                    sort.add(new ClusterEnrichment(tf, enrich, n, ratio, allTargetEnrich.get(tf), geneN, (Double)binP.get(tf), pVal, sign));
                }
                for (ClusterEnrichment en : sort) {
                    en.print(stream);
                }
                stream.close();
            }
        }
    }
}

