/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ChipSeq.IndexedSelection;
import org.rhwlab.encode.ChipSeq.ReleasedWormSelection;
import org.rhwlab.encode.ChipSeq.ViewBase;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.genetype.FlyGeneTypes;
import org.rhwlab.genetype.GeneTypes;
import org.rhwlab.genetype.WormGeneTypes;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.OrthologTF;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.Species;
import org.rhwlab.modern.TF;

public class ViewByTF
extends ViewBase
implements Serializable {
    IndexedSelection selection;

    public void buildTree() throws Exception {
        GeneTypes geneTypes = this.species.equalsIgnoreCase("worm") ? new WormGeneTypes() : new FlyGeneTypes();
        this.assembly = this.choosenAssembly();
        this.root = new Species(this.assembly, this.species, null);
        String[] allTFs = this.selection.getAllTFs();
        Arrays.sort(allTFs, new Comparator(){

            public int compare(Object o1, Object o2) {
                String s1 = (String)o1;
                String s2 = (String)o2;
                return s1.compareToIgnoreCase(s2);
            }
        });
        for (String tf : allTFs) {
            String[] orthologs = this.selection.getOrthologs(tf);
            TF tfNode = null;
            TreeMap<String, String[]> stages = this.selection.getAccessionsForTF(tf);
            for (String stage : stages.keySet()) {
                String[] expAccs;
                for (String expAcc : expAccs = stages.get(stage)) {
                    EncodeObject expObj = this.selection.getEncodeObject(expAcc);
                    Experiment exp = new Experiment(expObj.getJsonObject());
                    if (tfNode == null) {
                        if (orthologs == null) {
                            tfNode = new TF(this.assembly, tf, this.root, geneTypes.getType(tf));
                        } else {
                            tfNode = new OrthologTF(this.assembly, tf, this.root, geneTypes.getType(tf));
                            ArrayList<String> oList = new ArrayList<String>();
                            for (String ortholog : orthologs) {
                                oList.add(ortholog);
                            }
                            ((OrthologTF)tfNode).setOrthologs(oList);
                        }
                    }
                    tfNode.setDbxref(exp.getDbxref());
                    LifeStage stageNode = new LifeStage(this.assembly, exp, (TreeNode)tfNode);
                    this.addFiles((TreeNode)stageNode, exp, this.assembly);
                }
            }
        }
        this.peaksUrlsMap.clear();
        this.addPeaksURLs(this.root, this.peaksUrlsMap);
    }

    public TreeNode getRoot() throws Exception {
        String choosen = this.choosenAssembly();
        if (this.root == null || !choosen.equals(this.assembly)) {
            this.buildTree();
        }
        return this.root;
    }

    @Override
    public String getZipFileName() {
        return String.format("%sByTF.zip", this.species);
    }

    public void setSelection(IndexedSelection s) {
        this.selection = s;
    }

    public List<TF> getAllTFs() throws Exception {
        ArrayList<TF> ret = new ArrayList<TF>();
        TreeNode root = this.getRoot();
        for (TreeNode node : root.getChildren()) {
            ret.add((TF)node);
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        ViewByTF vbs = new ViewByTF();
        vbs.setSpecies("worm");
        vbs.setGenomes(new ReferenceGenome());
        File dir = new File("/net/waterston/vol2/home/gevirl/ReleasedWormChipSeqExperiments");
        ReleasedWormSelection sel = new ReleasedWormSelection(dir);
        vbs.setSelection(sel);
        vbs.buildTree();
        boolean uiashdfs = false;
    }
}

