/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ChipSeq.IndexedSelection;
import org.rhwlab.encode.ChipSeq.ReleasedWormSelection;
import org.rhwlab.encode.ChipSeq.ViewBase;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.genetype.FlyGeneTypes;
import org.rhwlab.genetype.GeneTypes;
import org.rhwlab.genetype.WormGeneTypes;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.OrthologTF;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.Species;
import org.rhwlab.modern.TF;

public class ViewByStage
extends ViewBase
implements Serializable {
    IndexedSelection selection;

    public void buildTree() throws Exception {
        GeneTypes geneTypes = this.species.equalsIgnoreCase("worm") ? new WormGeneTypes() : new FlyGeneTypes();
        this.assembly = this.choosenAssembly();
        this.root = new Species(this.assembly, this.species, null);
        Object[] allStages = this.selection.getAllStages();
        Arrays.sort(allStages);
        for (Object stage : allStages) {
            LifeStage stageNode = new LifeStage((String)stage, this.root);
            TreeMap<String, String[]> tfs = this.selection.getAccessionsForStage((String)stage);
            for (String tf : tfs.keySet()) {
                String[] expAccs;
                for (String expAcc : expAccs = tfs.get(tf)) {
                    TF tfNode;
                    EncodeObject expObj = this.selection.getEncodeObject(expAcc);
                    Experiment exp = new Experiment(expObj.getJsonObject());
                    String[] orthologs = this.selection.getOrthologs(tf);
                    if (orthologs == null) {
                        tfNode = new TF(this.assembly, exp, (TreeNode)stageNode, geneTypes.getType(tf));
                    } else {
                        tfNode = new OrthologTF(this.assembly, exp, (TreeNode)stageNode, geneTypes.getType(tf));
                        ArrayList<String> oList = new ArrayList<String>();
                        for (String ortholog : orthologs) {
                            oList.add(ortholog);
                        }
                        ((OrthologTF)tfNode).setOrthologs(oList);
                    }
                    this.addFiles((TreeNode)tfNode, exp, this.assembly);
                }
            }
        }
        this.peaksUrlsMap.clear();
        this.addPeaksURLs(this.root, this.peaksUrlsMap);
    }

    public TreeNode getRoot() throws Exception {
        String choosen = this.choosenAssembly();
        if (this.root == null || !choosen.equals(this.assembly)) {
            this.buildTree();
        }
        return this.root;
    }

    @Override
    public String getZipFileName() {
        return String.format("%sByStage.zip", this.species);
    }

    public void setSelection(IndexedSelection s) {
        this.selection = s;
    }

    public static void main(String[] args) throws Exception {
        ViewByStage vbs = new ViewByStage();
        vbs.setSpecies("worm");
        vbs.setGenomes(new ReferenceGenome());
        File dir = new File("/net/waterston/vol2/home/gevirl/ReleasedWormChipSeqExperiments");
        ReleasedWormSelection sel = new ReleasedWormSelection(dir);
        vbs.setSelection(sel);
        vbs.buildTree();
        boolean uiashdfs = false;
    }
}

