/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ChipSeq.FileView;
import org.rhwlab.modern.ControlFile;
import org.rhwlab.modern.DCCFile;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.ExperimentalFile;
import org.rhwlab.modern.FileType;
import org.rhwlab.modern.RecordBase;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.TreeNodeRecord;

public abstract class ViewBase
implements FileView {
    public TreeNode root;
    public TreeNode[] selectedNodes;
    public TreeMap<String, URL> urlsMap = new TreeMap();
    TreeMap<String, URL> peaksUrlsMap = new TreeMap();
    public ReferenceGenome genomes;
    String assembly;
    public String species;

    public void setGenomes(ReferenceGenome gen) {
        this.genomes = gen;
    }

    public void setSpecies(String sp) {
        this.species = sp;
    }

    @Override
    public String getSpecies() {
        return this.species;
    }

    @Override
    public Map<String, URL> getURLs() {
        return this.urlsMap;
    }

    @Override
    public Map<String, URL> getURLs(String param) throws Exception {
        TreeMap<String, URL> ret = new TreeMap<String, URL>();
        String[] keys = param.split("/");
        RecordBase base = ((RecordBase)this.root).findRecord(keys, 0);
        if (base != null) {
            ViewBase.addURLs((TreeNode)base, ret);
        }
        return ret;
    }

    @Override
    public Map<String, URL> getAllPeaksURLs() {
        return this.peaksUrlsMap;
    }

    public String choosenAssembly() {
        String ret = this.species.equalsIgnoreCase("worm") ? this.genomes.getWorm() : this.genomes.getFly();
        return ret;
    }

    public TreeNode[] getSelectedNodes() {
        return this.selectedNodes;
    }

    public void setSelectedNodes(TreeNode[] selectedNodes) throws Exception {
        this.selectedNodes = selectedNodes;
        this.urlsMap.clear();
        if (selectedNodes == null) {
            return;
        }
        for (TreeNode treeNode : selectedNodes) {
            ViewBase.addURLs(treeNode, this.urlsMap);
        }
    }

    public void addTrackHUBFileURLs(TreeNode node, Map<String, URL> urls) throws Exception {
        Object data = node.getData();
        if (data instanceof ExperimentalFile) {
            ExperimentalFile subFile = (ExperimentalFile)data;
            String identifier = subFile.getHubIdentifier();
            if (identifier.endsWith("bw") || identifier.endsWith("bb") || identifier.endsWith("Peak.gz")) {
                urls.put(identifier, new URL(subFile.getDownloadLink()));
            }
        } else {
            for (TreeNode child : node.getChildren()) {
                this.addTrackHUBFileURLs(child, urls);
            }
        }
    }

    public void addPeaksURLs(TreeNode node, Map<String, URL> urls) throws Exception {
        Object data = node.getData();
        if (data instanceof ExperimentalFile) {
            ExperimentalFile subFile = (ExperimentalFile)data;
            String id = subFile.getId().toLowerCase();
            if (id.contains("optimal") && id.endsWith(".gz")) {
                urls.put(String.format("%s/%s/%s", this.species, subFile.getAssembly(), subFile.getAccession() + "_" + subFile.getId()), new URL(subFile.getDownloadLink()));
            }
        } else {
            for (TreeNode child : node.getChildren()) {
                this.addPeaksURLs(child, urls);
            }
        }
    }

    public static void addURLs(TreeNode node, Map<String, URL> urls) throws Exception {
        Object data = node.getData();
        if (data instanceof ExperimentalFile) {
            ExperimentalFile subFile = (ExperimentalFile)data;
            urls.put(ViewBase.nodeIdentifier(node), new URL(subFile.getDownloadLink()));
        } else {
            for (TreeNode child : node.getChildren()) {
                ViewBase.addURLs(child, urls);
            }
        }
    }

    public static String nodeIdentifier(TreeNode node) {
        TreeNodeRecord record = (TreeNodeRecord)node.getData();
        if (node.getParent() == null) {
            return String.format("/%s", record.getId());
        }
        return String.format("%s/%s", ViewBase.nodeIdentifier(node.getParent()), record.getId());
    }

    public void addFiles(TreeNode root, Experiment exp, String genome) {
        TreeMap<String, List<DCCFile>> fileMap = new TreeMap<String, List<DCCFile>>();
        this.mapFilesForAccession(exp, genome, fileMap);
        TreeMap<String, List<DCCFile>> controlFileMap = new TreeMap<String, List<DCCFile>>();
        if (exp.getInput() != null) {
            this.mapFilesForAccession(exp.getInput(), genome, controlFileMap);
        }
        for (String key : fileMap.keySet()) {
            List<DCCFile> list = fileMap.get(key);
            FileType keyNode = new FileType(key, genome, root);
            for (DCCFile file : list) {
                if (!file.getStatus().equalsIgnoreCase("released")) continue;
                ExperimentalFile experimentalFile = new ExperimentalFile(file, (TreeNode)keyNode);
            }
            List<DCCFile> cFiles = controlFileMap.get(key);
            if (cFiles == null) continue;
            for (DCCFile file : cFiles) {
                if (!file.getStatus().equalsIgnoreCase("released")) continue;
                ControlFile controlFile = new ControlFile(file, (TreeNode)keyNode);
            }
        }
    }

    private void mapFilesForAccession(Experiment exp, String genome, TreeMap<String, List<DCCFile>> fileMap) {
        DCCFile[] files = exp.getFiles();
        for (int i = 0; i < files.length; ++i) {
            String assembly = files[i].getAssembly();
            if (assembly != null && !assembly.equals(genome)) continue;
            String key = files[i].getOutputType();
            List<DCCFile> list = fileMap.get(key);
            if (list == null) {
                list = new ArrayList<DCCFile>();
                fileMap.put(key, list);
            }
            list.add(files[i]);
        }
    }
}

