/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.File;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.UCSC.TrackHub;
import org.rhwlab.encode.ChipSeq.IndexedSelection;
import org.rhwlab.encode.ChipSeq.ReleasedFlySelection;
import org.rhwlab.encode.ChipSeq.ReleasedWormSelection;
import org.rhwlab.encode.ChipSeq.ViewByTF;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.TF;

public class TrackHubs {
    public static void main(String[] args) throws Exception {
        File hubDir = new File(args[0]);
        ReleasedFlySelection fly = new ReleasedFlySelection(new File(hubDir, "ReleasedFlyChipSeqExperiments"));
        ReleasedWormSelection worm = new ReleasedWormSelection(new File(hubDir, "ReleasedWormChipSeqExperiments"));
        ReferenceGenome genome = new ReferenceGenome();
        TreeMap<String, String[]> assemblyMap = new TreeMap<String, String[]>();
        String[] flyAssemblies = new String[]{"dm3", "dm6"};
        String[] wormAssemblies = new String[]{"ce10", "ce11"};
        assemblyMap.put("fly", flyAssemblies);
        for (String species : assemblyMap.keySet()) {
            ViewByTF view = new ViewByTF();
            view.setGenomes(genome);
            view.setSpecies(species);
            IndexedSelection selection = null;
            selection = species.equals("worm") ? worm : fly;
            view.setSelection(selection);
            TreeNode[] roots = new TreeNode[((String[])assemblyMap.get(species)).length];
            String[] assemblies = (String[])assemblyMap.get(species);
            for (int i = 0; i < assemblies.length; ++i) {
                roots[i] = view.getRoot();
            }
            for (TF tf : view.getAllTFs()) {
                TrackHub.formTFhtml(tf, hubDir);
                TrackHub.formHub(tf.getId(), roots, hubDir, species, assemblies);
                boolean bl = false;
            }
            TrackHub.formHub(null, roots, hubDir, species, assemblies);
        }
    }
}

