/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.rhwlab.cgc.CGCStrain;
import org.rhwlab.encode.ChipSeq.IndexedSelection;
import org.rhwlab.encode.ChipSeq.ReleasedWormExperiment;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.modern.Experiment;

public class ReleasedWormSelection
extends IndexedSelection
implements Serializable {
    public ReleasedWormSelection(File dir) throws Exception {
        super(dir, ((ReleasedWormExperiment)ReleasedWormExperiment.class.newInstance()).getClass());
    }

    public ReleasedWormSelection() throws Exception {
        super(((ReleasedWormExperiment)ReleasedWormExperiment.class.newInstance()).getClass());
    }

    public void cgcStrains() throws Exception {
        if (this.indexedDir == null) {
            this.indexedDir = new File(this.getDirectory()).getParentFile();
        }
        for (int i = 0; i < this.getObjectCount(); ++i) {
            CGCStrain cgc;
            String url;
            EncodeObject expObj = this.getEncodeObject(i);
            Experiment exp = new Experiment(expObj.getJsonObject());
            String strain = exp.getStrain();
            if (strain == null) continue;
            File strainsDir = new File(this.indexedDir, "strains");
            Files.createDirectories(strainsDir.toPath(), new FileAttribute[0]);
            File strainFile = new File(strainsDir, strain);
            if (strainFile.exists() || (url = (cgc = new CGCStrain(strain)).getUrl()) == null) continue;
            PrintStream stream = new PrintStream(strainFile);
            stream.println(url);
            stream.close();
        }
    }
}

