/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rhwlab.UCSC.AggregateBed;
import org.rhwlab.chipseq.ChipSeqBedRecord;
import org.rhwlab.encode.ChipSeq.ReleasedWormSelection;
import org.rhwlab.encode.ChipSeq.ViewByTF;
import org.rhwlab.encode.ChipSeq.peaks.PeakClusters;
import org.rhwlab.encode.ChipSeq.peaks.PeakFile;
import org.rhwlab.gene.model.ModelFromGFF;
import org.rhwlab.modern.ReferenceGenome;

public class PeakBeds {
    static final Set<String> embryonicStages = new TreeSet<String>(Arrays.asList("earlyembryonic", "lateembryonic", "midembryonic", "mixedstage(embryonic)"));
    static final Set<String> earlyLarvalStages = new TreeSet<String>(Arrays.asList("L1larva", "L2larva", "L3larva"));
    static final Set<String> embryonicLarvalStages = new TreeSet<String>();
    static final Map<String, Set<String>> stageSets = new TreeMap<String, Set<String>>();

    public static void makeAllWormStageSets(String dir, String assembly) throws Exception {
        ModelFromGFF gff3 = new ModelFromGFF(new File("/net/waterston/vol9/References/WS245/AllWormBase.withTransposon.gff3"));
        for (String label : stageSets.keySet()) {
            Set<String> stageSet = stageSets.get(label);
            PeakBeds.makeWormPeakBeds(dir, assembly, gff3, stageSet, label);
        }
    }

    public static void makeWormPeakBeds(String dir, String assembly, ModelFromGFF gff3, Set<String> stages, String label) throws Exception {
        String species = "worm";
        ReleasedWormSelection worm = new ReleasedWormSelection(new File(dir, "ReleasedWormChipSeqExperiments"));
        ReferenceGenome genome = new ReferenceGenome();
        genome.setAssembly(species, assembly);
        ViewByTF view = new ViewByTF();
        view.setGenomes(genome);
        view.setSpecies(species);
        view.setSelection(worm);
        AggregateBed aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz", stages);
        File assemblyDir = new File(dir, assembly);
        Files.createDirectories(assemblyDir.toPath(), new FileAttribute[0]);
        File narrowBedFile = new File(assemblyDir, label + "narrowPeak.bed");
        File narrowBBFile = new File(assemblyDir, label + "narrowPeak.bb");
        File singleBedFile = new File(assemblyDir, label + "singlePeak.bed");
        File singleBBFile = new File(assemblyDir, label + "singlePeak.bb");
        aggBed.writeTo(narrowBedFile);
        String cmd = String.format("/net/waterston/vol9/bedSort  %s  %s.sort", narrowBedFile.getPath(), narrowBedFile.getPath());
        Process p = Runtime.getRuntime().exec(cmd);
        p.waitFor();
        cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+4 -as=/net/waterston/vol9/narrowPeak.as  %s.sort /net/waterston/vol9/%s.chrom.sizes %s", narrowBedFile.getPath(), assembly, narrowBBFile.getPath());
        p = Runtime.getRuntime().exec(cmd);
        p.waitFor();
        aggBed.writePointBedTo(singleBedFile);
        cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+3  %s /net/waterston/vol9/%s.chrom.sizes %s", singleBedFile.getPath(), assembly, singleBBFile.getPath());
        p = Runtime.getRuntime().exec(cmd);
        p.waitFor();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", narrowBedFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", singleBedFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", narrowBBFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", singleBBFile.getPath()));
        File annotBedFile = new File(assemblyDir, label + "annotatedPeak.bed");
        File peakClusterBedFile = new File(assemblyDir, label + "PeakClusters.bed");
        File peakClusterTabFile = new File(assemblyDir, label + "PeakClusters.tab");
        File peakClusterBBFile = new File(assemblyDir, label + "PeakClusters.bb");
        ArrayList<PeakFile> peakFiles = new ArrayList<PeakFile>();
        TreeMap<String, List<ChipSeqBedRecord>> map = aggBed.getBedRecords();
        for (String tf : map.keySet()) {
            peakFiles.add(new PeakFile(map.get(tf), tf));
        }
        PeakClusters peakClusters = new PeakClusters(peakFiles, 60);
        peakClusters.locateInGenome(gff3);
        peakClusters.report(peakClusterTabFile);
        peakClusters.toBedFormat(peakClusterBedFile.getPath());
        cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed9  %s /net/waterston/vol9/%s.chrom.sizes %s", peakClusterBedFile.getPath(), assembly, peakClusterBBFile.getPath());
        p = Runtime.getRuntime().exec(cmd);
        p.waitFor();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", peakClusterBBFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", peakClusterTabFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", peakClusterBedFile.getPath()));
        Runtime.getRuntime().exec(String.format("chmod 666 %s", annotBedFile.getPath()));
        aggBed.writeTo(annotBedFile);
        boolean iushfu = false;
    }

    public static void main(String[] args) throws Exception {
        String dir = args[0];
        PeakBeds.makeAllWormStageSets(dir, "ce11");
    }

    static {
        embryonicLarvalStages.addAll(embryonicStages);
        embryonicLarvalStages.addAll(earlyLarvalStages);
        stageSets.put("", null);
        stageSets.put("EarlyLarval", earlyLarvalStages);
        stageSets.put("Embryonic", embryonicStages);
        stageSets.put("EmbryonicLarval", embryonicLarvalStages);
    }
}

