/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.primefaces.model.TreeNode;
import org.rhwlab.UCSC.AggregateBed;
import org.rhwlab.UCSC.TrackHub;
import org.rhwlab.chipseq.ChipSeqBedRecord;
import org.rhwlab.encode.ChipSeq.IndexedSelection;
import org.rhwlab.encode.ChipSeq.ReleasedFlySelection;
import org.rhwlab.encode.ChipSeq.ReleasedWormSelection;
import org.rhwlab.encode.ChipSeq.ViewByTF;
import org.rhwlab.encode.ChipSeq.peaks.PeakClusters;
import org.rhwlab.encode.ChipSeq.peaks.PeakFile;
import org.rhwlab.encode.objects.Experiment;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.TF;

public class Orthologs {
    public TreeMap buildOrthologMap(String file) throws Exception {
        TreeMap<String, ArrayList<String>> ret = new TreeMap<String, ArrayList<String>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file)));
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split("\t");
            ArrayList<String> list = (ArrayList<String>)ret.get(tokens[0]);
            if (list == null) {
                list = new ArrayList<String>();
                ret.put(tokens[0], list);
            }
            list.add(tokens[1]);
            line = reader.readLine();
        }
        reader.close();
        return ret;
    }

    public static void formLinks(IndexedSelection fromSel, IndexedSelection toSel, TreeMap<String, List<String>> orthologMap) throws Exception {
        TreeMap<String, String> toNameMap = toSel.getDbxrefsToGeneName();
        for (int i = 0; i < fromSel.getObjectCount(); ++i) {
            List<String> orthologList;
            Experiment exp = (Experiment)fromSel.getEncodeObject(i);
            String geneName = exp.getGeneName();
            String dbxref = exp.getDbxref();
            if (geneName == null || dbxref == null || (orthologList = orthologMap.get(dbxref)) == null) continue;
            for (String orthoDbxref : orthologList) {
                String orthoGene = toNameMap.get(orthoDbxref);
                if (orthoGene == null) continue;
                fromSel.orthoLink(geneName, toSel, orthoGene);
            }
        }
    }

    public static void reportLinks(IndexedSelection fromSel, IndexedSelection toSel, TreeMap<String, List<String>> orthologMap) throws Exception {
        TreeMap<String, String> toNameMap = toSel.getDbxrefsToGeneName();
        for (int i = 0; i < fromSel.getObjectCount(); ++i) {
            List<String> orthologList;
            Experiment exp = (Experiment)fromSel.getEncodeObject(i);
            String geneName = exp.getGeneName();
            String dbxref = exp.getDbxref();
            if (geneName == null || dbxref == null || (orthologList = orthologMap.get(dbxref)) == null) continue;
            for (String orthoDbxref : orthologList) {
                String orthoGene = toNameMap.get(orthoDbxref);
                if (orthoGene == null) continue;
                System.out.printf("%s\t%s\n", geneName, orthoGene);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        File hubDir = new File(args[0]);
        Orthologs ortho = new Orthologs();
        ReleasedWormSelection worm = new ReleasedWormSelection();
        worm.saveToDirectory(new File(args[0], "ReleasedWormChipSeqExperiments"));
        worm.indexDirectory();
        worm.cgcStrains();
        ReleasedFlySelection fly = new ReleasedFlySelection();
        fly.saveToDirectory(new File(args[0], "ReleasedFlyChipSeqExperiments"));
        fly.indexDirectory();
        Orthologs.formLinks(fly, worm, ortho.buildOrthologMap("/org/rhwlab/encode/ortholog/FBgnToWBGene.all.orthologs"));
        Orthologs.formLinks(worm, fly, ortho.buildOrthologMap("/org/rhwlab/encode/ortholog/WBGeneToFBgn.all.orthologs"));
        ReferenceGenome genome = new ReferenceGenome();
        TreeMap<String, String[]> assemblyMap = new TreeMap<String, String[]>();
        String[] flyAssemblies = new String[]{"dm3", "dm6"};
        String[] wormAssemblies = new String[]{"ce10", "ce11"};
        assemblyMap.put("worm", wormAssemblies);
        assemblyMap.put("fly", flyAssemblies);
        for (String species : assemblyMap.keySet()) {
            for (String assembly : (String[])assemblyMap.get(species)) {
                ViewByTF view = new ViewByTF();
                view.setGenomes(genome);
                view.setSpecies(species);
                if (species.equals("worm")) {
                    view.setSelection(worm);
                } else {
                    view.setSelection(fly);
                }
                genome.setAssembly(species, assembly);
                AggregateBed aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz");
                File assemblyDir = new File(args[0], assembly);
                Files.createDirectories(assemblyDir.toPath(), new FileAttribute[0]);
                File narrowBedFile = new File(assemblyDir, "narrowPeak.bed");
                File narrowBBFile = new File(assemblyDir, "narrowPeak.bb");
                File singleBedFile = new File(assemblyDir, "singlePeak.bed");
                File singleBBFile = new File(assemblyDir, "singlePeak.bb");
                File peakClusterBedFile = new File(assemblyDir, "peakClusters.bed");
                File peakClusterBBFile = new File(assemblyDir, "peakClusters.bb");
                aggBed.writeTo(narrowBedFile);
                String cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+4 -as=/net/waterston/vol9/narrowPeak.as  %s /net/waterston/vol9/%s.chrom.sizes %s", narrowBedFile.getPath(), assembly, narrowBBFile.getPath());
                Process p = Runtime.getRuntime().exec(cmd);
                p.waitFor();
                aggBed.writePointBedTo(singleBedFile);
                cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed6+3  %s /net/waterston/vol9/%s.chrom.sizes %s", singleBedFile.getPath(), assembly, singleBBFile.getPath());
                p = Runtime.getRuntime().exec(cmd);
                p.waitFor();
                Runtime.getRuntime().exec(String.format("chmod 666 %s", narrowBBFile.getPath()));
                Runtime.getRuntime().exec(String.format("chmod 666 %s", singleBBFile.getPath()));
                ArrayList<PeakFile> peakFiles = new ArrayList<PeakFile>();
                TreeMap<String, List<ChipSeqBedRecord>> map = aggBed.getBedRecords();
                for (String tf : map.keySet()) {
                    peakFiles.add(new PeakFile(map.get(tf), tf));
                }
                PeakClusters peakClusters = new PeakClusters(peakFiles, 60);
                peakClusters.toBedFormat(peakClusterBedFile.getPath());
                cmd = String.format("/net/waterston/vol9/bedToBigBed -type=bed9  %s /net/waterston/vol9/%s.chrom.sizes %s", peakClusterBedFile.getPath(), assembly, peakClusterBBFile.getPath());
                p = Runtime.getRuntime().exec(cmd);
                p.waitFor();
            }
        }
        for (String species : assemblyMap.keySet()) {
            ViewByTF view = new ViewByTF();
            view.setGenomes(genome);
            view.setSpecies(species);
            IndexedSelection selection = null;
            selection = species.equals("worm") ? worm : fly;
            view.setSelection(selection);
            TreeNode[] roots = new TreeNode[((String[])assemblyMap.get(species)).length];
            String[] assemblies = (String[])assemblyMap.get(species);
            for (int i = 0; i < assemblies.length; ++i) {
                roots[i] = view.getRoot();
            }
            for (TF tf : view.getAllTFs()) {
                TrackHub.formTFhtml(tf, hubDir);
                TrackHub.formHub(tf.getId(), roots, hubDir, species, assemblies);
                boolean bl = false;
            }
        }
    }
}

