/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.primefaces.model.TreeNode;
import org.rhwlab.encode.ChipSeq.IndexedSelection;
import org.rhwlab.encode.ChipSeq.ViewBase;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.genetype.FlyGeneTypes;
import org.rhwlab.genetype.GeneTypes;
import org.rhwlab.genetype.WormGeneTypes;
import org.rhwlab.modern.Experiment;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.OrthologTF;
import org.rhwlab.modern.Species;
import org.rhwlab.modern.TF;

public class OrthologView
extends ViewBase
implements Serializable {
    String dbxref;
    IndexedSelection wormSelection;
    IndexedSelection flySelection;
    String title;
    String commonName;

    public OrthologView() {
        HttpServletRequest req = (HttpServletRequest)FacesContext.getCurrentInstance().getExternalContext().getRequest();
        this.dbxref = req.getParameter("TF");
        this.species = this.dbxref.startsWith("WB") ? "worm" : "fly";
    }

    public TreeNode getRoot() throws Exception {
        String choosen = this.choosenAssembly();
        if (this.root == null || !choosen.equals(this.assembly)) {
            this.buildTree();
        }
        return this.root;
    }

    public void buildTree() throws Exception {
        String[] orthoTFs;
        IndexedSelection selection;
        GeneTypes geneTypes;
        if (this.dbxref.startsWith("FB")) {
            geneTypes = new WormGeneTypes();
            selection = this.wormSelection;
            orthoTFs = this.flySelection.getOrthologsFromDbxref(this.dbxref);
            this.commonName = this.flySelection.getCommonName(this.dbxref);
            this.assembly = this.genomes.getWorm();
        } else {
            geneTypes = new FlyGeneTypes();
            selection = this.flySelection;
            orthoTFs = this.wormSelection.getOrthologsFromDbxref(this.dbxref);
            this.commonName = this.wormSelection.getCommonName(this.dbxref);
            this.assembly = this.genomes.getFly();
        }
        this.root = new Species(this.assembly, this.species, null);
        if (orthoTFs == null) {
            return;
        }
        for (String tf : orthoTFs) {
            String[] orthologs = selection.getOrthologs(tf);
            TF tfNode = null;
            TreeMap<String, String[]> stages = selection.getAccessionsForTF(tf);
            for (String stage : stages.keySet()) {
                String[] expAccs;
                for (String expAcc : expAccs = stages.get(stage)) {
                    EncodeObject expObj = selection.getEncodeObject(expAcc);
                    Experiment exp = new Experiment(expObj.getJsonObject());
                    if (tfNode == null) {
                        if (orthologs == null) {
                            tfNode = new TF(this.assembly, tf, this.root, geneTypes.getType(tf));
                        } else {
                            tfNode = new OrthologTF(this.assembly, tf, this.root, geneTypes.getType(tf));
                            ArrayList<String> oList = new ArrayList<String>();
                            for (String ortholog : orthologs) {
                                oList.add(ortholog);
                            }
                            ((OrthologTF)tfNode).setOrthologs(oList);
                        }
                    }
                    tfNode.setDbxref(exp.getDbxref());
                    LifeStage stageNode = new LifeStage(this.assembly, exp, (TreeNode)tfNode);
                    this.addFiles((TreeNode)stageNode, exp, this.assembly);
                }
            }
        }
        this.peaksUrlsMap.clear();
        this.addPeaksURLs(this.root, this.peaksUrlsMap);
    }

    public void setWormSelection(IndexedSelection s) {
        this.wormSelection = s;
    }

    public void setFlySelection(IndexedSelection s) {
        this.flySelection = s;
    }

    @Override
    public String getZipFileName() {
        return String.format("%s_Ortholog.zip", this.dbxref);
    }

    public String getTitle() {
        this.title = "ChipSeq";
        if (this.dbxref != null && this.commonName != null) {
            this.title = String.format("ChipSeq for Ortholog(s) of %s", this.commonName);
        }
        return this.title;
    }

    public String getUpdatedlast() {
        return this.flySelection.getUpdatedLast();
    }
}

