/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.encode.ChipSeq;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeMap;
import org.rhwlab.encode.objects.EncodeObject;
import org.rhwlab.encode.objects.Selection;
import org.rhwlab.modern.Experiment;

public class IndexedSelection
extends Selection
implements Serializable {
    File indexedDir;

    public IndexedSelection(File dir, Class c) throws Exception {
        super(new File(dir, "experiments"), c);
        this.indexedDir = dir;
    }

    public IndexedSelection(Class c) throws Exception {
        super(c);
    }

    @Override
    public void setDirectory(String inDir) {
        this.indexedDir = new File(inDir);
        super.setDirectory(new File(inDir, "experiments").getPath());
    }

    public void indexDirectory() throws Exception {
        if (this.indexedDir == null) {
            this.indexedDir = new File(this.getDirectory()).getParentFile();
        }
        for (int i = 0; i < this.getObjectCount(); ++i) {
            EncodeObject expObj = this.getEncodeObject(i);
            Experiment exp = new Experiment(expObj.getJsonObject());
            if (exp.isControl()) continue;
            String stage = exp.getStage().replaceAll(" ", "");
            stage = stage.replace('/', '_');
            String tf = exp.getGene();
            Path tfstageDir = this.tfStageDir(tf, stage).toPath();
            Path stagetfDir = this.stageTfDir(stage, tf).toPath();
            if (exp.getDbxref() != null) {
                Path dbxrefTFDir = this.dbxrefTFDir(exp.getDbxref(), tf).toPath();
                Files.createDirectories(this.dbxrefDir(exp.getDbxref()).toPath(), new FileAttribute[0]);
                if (!dbxrefTFDir.toFile().exists()) {
                    Files.createSymbolicLink(dbxrefTFDir, this.tfDir(tf).toPath(), new FileAttribute[0]);
                }
            }
            Files.createDirectories(tfstageDir, new FileAttribute[0]);
            Files.createDirectories(stagetfDir, new FileAttribute[0]);
            String acc = exp.getAccession();
            Path toExp = new File(new File(this.indexedDir, "experiments"), acc).toPath();
            File file = new File(tfstageDir.toFile(), acc);
            if (!file.exists()) {
                Files.createLink(file.toPath(), toExp);
            }
            if ((file = new File(stagetfDir.toFile(), acc)).exists()) continue;
            Files.createLink(file.toPath(), toExp);
        }
    }

    public String[] getAllStages() {
        File stagesDir = this.stagesDir();
        return stagesDir.list();
    }

    public TreeMap<String, String[]> getAccessionsForStage(String stage) {
        String[] tfs;
        TreeMap<String, String[]> ret = new TreeMap<String, String[]>();
        File stageDir = this.stagesDir();
        for (String tf : tfs = new File(stageDir, stage).list()) {
            File tfDir = this.stageTfDir(stage, tf);
            ret.put(tf, tfDir.list());
        }
        return ret;
    }

    public String[] getAllTFs() {
        File tfsDir = this.tfsDir();
        return tfsDir.list();
    }

    public TreeMap<String, String[]> getAccessionsForTF(String tf) {
        String[] stages;
        TreeMap<String, String[]> ret = new TreeMap<String, String[]>();
        File tfDir = this.tfsDir();
        for (String stage : stages = this.tfStagesDir(tf).list()) {
            File stageDir = this.tfStageDir(tf, stage);
            ret.put(stage, stageDir.list());
        }
        return ret;
    }

    public TreeMap<String, String> getDbxrefsToGeneName() throws Exception {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (int i = 0; i < this.getObjectCount(); ++i) {
            org.rhwlab.encode.objects.Experiment exp = (org.rhwlab.encode.objects.Experiment)this.getEncodeObject(i);
            String dbxref = exp.getDbxref();
            String geneName = exp.getGeneName();
            if (geneName != null && dbxref != null) {
                ret.put(dbxref, geneName);
                continue;
            }
            boolean bl = false;
        }
        return ret;
    }

    private File tfsDir() {
        return new File(this.indexedDir, "tfs");
    }

    private File dbxrefsDir() {
        return new File(this.indexedDir, "dbxrefs");
    }

    private File dbxrefDir(String dbxref) {
        return new File(this.dbxrefsDir(), dbxref);
    }

    private File dbxrefTFDir(String dbxref, String tf) {
        return new File(this.dbxrefDir(dbxref), tf);
    }

    private File tfDir(String tf) {
        return new File(this.tfsDir(), tf);
    }

    private File tfStagesDir(String tf) {
        return new File(this.tfDir(tf), "stages");
    }

    private File tfStageDir(String tf, String stage) {
        return new File(this.tfStagesDir(tf), stage);
    }

    private File stagesDir() {
        return new File(this.indexedDir, "stages");
    }

    private File stageDir(String stage) {
        return new File(this.stagesDir(), stage);
    }

    private File stageTfDir(String stage, String tf) {
        return new File(this.stageDir(stage), tf);
    }

    private File orthologsDir(String tf) {
        return new File(this.tfDir(tf), "orthologs");
    }

    private File orthologDir(String tf, String ortholog) {
        return new File(this.orthologsDir(tf), ortholog);
    }

    public void orthoLink(String fromGene, IndexedSelection toSel, String toGene) throws Exception {
        Path orthologsPath = this.orthologsDir(fromGene).toPath();
        Files.createDirectories(orthologsPath, new FileAttribute[0]);
        Path orthologPath = this.orthologDir(fromGene, toGene).toPath();
        if (!orthologPath.toFile().exists()) {
            Path toPath = toSel.tfDir(toGene).toPath();
            Files.createSymbolicLink(orthologPath, toPath, new FileAttribute[0]);
        }
    }

    public String[] getOrthologs(String tf) {
        File dir = this.orthologsDir(tf);
        if (dir.exists()) {
            return dir.list();
        }
        return null;
    }

    public String[] getOrthologsFromDbxref(String dbxref) {
        File dbxrefDir = this.dbxrefDir(dbxref);
        if (dbxrefDir != null) {
            String tf = dbxrefDir.list()[0];
            return this.getOrthologs(tf);
        }
        return new String[0];
    }

    public String getCommonName(String dbxref) {
        File dbxrefDir = this.dbxrefDir(dbxref);
        if (dbxrefDir != null) {
            return dbxrefDir.list()[0];
        }
        return "";
    }
}

