/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.UCSC;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.RecursiveAction;

public class DownloadFiles
extends RecursiveAction {
    TreeMap<String, URL> urlMap;
    static File dir = new File("/nfs/waterston");
    static final int thresh = 200;
    static final int BUFFER = 2048;

    public DownloadFiles(TreeMap<String, URL> urlMap) {
        this.urlMap = urlMap;
    }

    @Override
    protected void compute() {
        if (this.urlMap.size() > 200) {
            TreeMap<String, URL> lower = new TreeMap<String, URL>();
            for (int i = 0; i < this.urlMap.size() / 2; ++i) {
                Map.Entry<String, URL> entry = this.urlMap.pollFirstEntry();
                lower.put(entry.getKey(), entry.getValue());
            }
            RecursiveAction.invokeAll(new DownloadFiles(lower), new DownloadFiles(this.urlMap));
        } else {
            byte[] data = new byte[2048];
            for (String name : this.urlMap.keySet()) {
                URL url = this.urlMap.get(name);
                try {
                    BufferedInputStream inStream = new BufferedInputStream(url.openStream());
                    int n = inStream.read(data, 0, 2048);
                    File dest = new File(dir.getPath(), name);
                    Process p = Runtime.getRuntime().exec(String.format("mkdir -p %s", dest.getParent()));
                    p.waitFor();
                    PrintStream outStream = new PrintStream(dest);
                    outStream.write(data, 0, n);
                    while (n != -1) {
                        n = inStream.read(data, 0, 2048);
                        if (n <= 0) continue;
                        outStream.write(data, 0, n);
                    }
                    inStream.close();
                    outStream.close();
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
    }
}

