/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.UCSC;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import org.primefaces.model.TreeNode;
import org.rhwlab.chipseq.ChipSeqBedRecord;
import org.rhwlab.encode.ChipSeq.ReleasedWormSelection;
import org.rhwlab.encode.ChipSeq.ViewByTF;
import org.rhwlab.modern.ExperimentalFile;
import org.rhwlab.modern.FileType;
import org.rhwlab.modern.LifeStage;
import org.rhwlab.modern.RecordBase;
import org.rhwlab.modern.ReferenceGenome;
import org.rhwlab.modern.TF;

public class AggregateBed {
    ArrayList<ChipSeqBedRecord> bedRecords = new ArrayList();

    public AggregateBed(TreeNode root, String fileType, String fileExt, Set<String> stages) throws Exception {
        this.addFiles((RecordBase)root, fileType, fileExt, stages);
    }

    public AggregateBed(TreeNode root, String fileType, String fileExt) throws Exception {
        this(root, fileType, fileExt, null);
    }

    public TreeMap<String, List<ChipSeqBedRecord>> getBedRecords() {
        TreeMap<String, List<ChipSeqBedRecord>> ret = new TreeMap<String, List<ChipSeqBedRecord>>();
        for (ChipSeqBedRecord rec : this.bedRecords) {
            String tf = rec.getTF();
            List<ChipSeqBedRecord> bedRecs = ret.get(tf);
            if (bedRecs == null) {
                bedRecs = new ArrayList<ChipSeqBedRecord>();
                ret.put(tf, bedRecs);
            }
            bedRecs.add(rec);
        }
        return ret;
    }

    public void writeTo(File file) throws Exception {
        PrintStream stream = new PrintStream(file);
        for (ChipSeqBedRecord rec : this.bedRecords) {
            stream.println(rec.toString());
        }
        stream.close();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", file.getPath()));
    }

    public void writePointBedTo(File file) throws Exception {
        TreeSet<ChipSeqBedRecord> recs = new TreeSet<ChipSeqBedRecord>();
        PrintStream stream = new PrintStream(file);
        for (ChipSeqBedRecord rec : this.bedRecords) {
            recs.add(rec.toPointCoordinates());
        }
        for (ChipSeqBedRecord rec : recs) {
            stream.println(rec.toString());
        }
        stream.close();
        Runtime.getRuntime().exec(String.format("chmod 666 %s", file.getPath()));
    }

    private final void addFiles(RecordBase node, String filePrefix, String fileExt, Set<String> stageSet) throws Exception {
        block4: {
            block5: {
                block3: {
                    if (!(node instanceof FileType)) break block3;
                    FileType typeNode = (FileType)node;
                    LifeStage stageNode = (LifeStage)node.getParent();
                    TF tfNode = (TF)stageNode.getParent();
                    for (TreeNode child : node.getChildren()) {
                        ExperimentalFile fileNode = (ExperimentalFile)child;
                        if (!fileNode.getId().endsWith(fileExt) || !fileNode.getId().startsWith(filePrefix)) continue;
                        String fileName = fileNode.getId();
                        System.out.println(fileName);
                        URL url = new URL(fileNode.getDownloadLink());
                        AggregateBed.readBedRecords(tfNode.getId(), stageNode.getId(), url, this.bedRecords);
                    }
                    break block4;
                }
                if (!(node instanceof LifeStage) || stageSet == null) break block5;
                LifeStage lifeStage = (LifeStage)node;
                String stage = lifeStage.getId();
                stage = stage.replaceAll(" ", "");
                if (!stageSet.contains(stage = stage.replace('/', '_'))) break block4;
                for (TreeNode child : node.getChildren()) {
                    this.addFiles((RecordBase)child, filePrefix, fileExt, stageSet);
                }
                break block4;
            }
            for (TreeNode child : node.getChildren()) {
                this.addFiles((RecordBase)child, filePrefix, fileExt, stageSet);
            }
        }
    }

    public static void readBedRecords(String tf, String stage, URL url, ArrayList<ChipSeqBedRecord> bedRecords) throws Exception {
        InputStream urlInput = url.openStream();
        GZIPInputStream gzip = new GZIPInputStream(urlInput);
        BufferedReader reader = new BufferedReader(new InputStreamReader(gzip));
        String line = reader.readLine();
        while (line != null) {
            ChipSeqBedRecord rec = new ChipSeqBedRecord(line);
            rec.setName(String.format("%s_%s", tf, stage).replaceAll(" ", "_"));
            bedRecords.add(rec);
            line = reader.readLine();
        }
        reader.close();
    }

    public static void main(String[] args) throws Exception {
        ReleasedWormSelection worm = new ReleasedWormSelection(new File("/net/waterston/vol2/home/gevirl", "ReleasedWormChipSeqExperiments"));
        ReferenceGenome genome = new ReferenceGenome();
        ViewByTF view = new ViewByTF();
        view.setGenomes(genome);
        view.setSpecies("worm");
        view.setSelection(worm);
        genome.setAssembly("worm", "ce11");
        AggregateBed aggBed = new AggregateBed(view.getRoot(), "spp.optimal", "gz");
    }
}

