/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.ClientWindow;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutcomeTargetRenderer
extends CoreRenderer {
    protected NavigationCase findNavigationCase(FacesContext context, UIOutcomeTarget outcomeTarget) {
        String toFlowDocumentId;
        ConfigurableNavigationHandler navigationHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        String outcome = outcomeTarget.getOutcome();
        if (outcome == null) {
            outcome = context.getViewRoot().getViewId();
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isAtLeastJSF22() && outcomeTarget instanceof UIComponent && (toFlowDocumentId = (String)((UIComponent)outcomeTarget).getAttributes().get("to-flow-document-id")) != null) {
            return navigationHandler.getNavigationCase(context, null, outcome, toFlowDocumentId);
        }
        return navigationHandler.getNavigationCase(context, null, outcome);
    }

    protected Map<String, List<String>> getParams(NavigationCase navCase, UIOutcomeTarget outcomeTarget) {
        String toFlowDocumentId;
        Map<String, List<String>> params = outcomeTarget.getParams();
        Map navCaseParams = navCase.getParameters();
        if (navCaseParams != null && !navCaseParams.isEmpty()) {
            if (params == null) {
                params = new LinkedHashMap<String, List<String>>();
            }
            for (Map.Entry entry : navCaseParams.entrySet()) {
                String key = (String)entry.getKey();
                if (params.containsKey(key)) continue;
                params.put(key, (List<String>)entry.getValue());
            }
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isAtLeastJSF22() && (toFlowDocumentId = navCase.getToFlowDocumentId()) != null) {
            if (params == null) {
                params = new LinkedHashMap<String, List<String>>();
            }
            ArrayList<String> flowDocumentIdValues = new ArrayList<String>();
            flowDocumentIdValues.add(toFlowDocumentId);
            params.put("jftfdi", flowDocumentIdValues);
            if (!"javax.faces.flow.NullFlow".equals(toFlowDocumentId)) {
                ArrayList<String> flowIdValues = new ArrayList<String>();
                flowIdValues.add(navCase.getFromOutcome());
                params.put("jffi", flowIdValues);
            }
        }
        return params;
    }

    protected boolean isIncludeViewParams(UIOutcomeTarget outcomeTarget, NavigationCase navCase) {
        return outcomeTarget.isIncludeViewParams() || navCase.isIncludeViewParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getTargetURL(FacesContext context, UIOutcomeTarget outcomeTarget) {
        String url;
        block6: {
            String href = outcomeTarget.getHref();
            if (href != null) {
                return this.getResourceURL(context, href);
            }
            NavigationCase navCase = this.findNavigationCase(context, outcomeTarget);
            if (navCase == null) {
                throw new FacesException("Could not resolve NavigationCase for outcome: " + outcomeTarget.getOutcome());
            }
            String toViewId = navCase.getToViewId(context);
            boolean isIncludeViewParams = this.isIncludeViewParams(outcomeTarget, navCase);
            Map<String, List<String>> map = this.getParams(navCase, outcomeTarget);
            if (map == null) {
                Map map2 = Collections.emptyMap();
            }
            boolean clientWindowRenderingModeEnabled = false;
            ClientWindow clientWindow = null;
            try {
                void var8_10;
                if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isAtLeastJSF22() && outcomeTarget.isDisableClientWindow() && (clientWindow = context.getExternalContext().getClientWindow()) != null && (clientWindowRenderingModeEnabled = clientWindow.isClientWindowRenderModeEnabled(context))) {
                    clientWindow.disableClientWindowRenderMode(context);
                }
                url = context.getApplication().getViewHandler().getBookmarkableURL(context, toViewId, (Map)var8_10, isIncludeViewParams);
                if (!clientWindowRenderingModeEnabled || clientWindow == null) break block6;
            }
            catch (Throwable throwable) {
                if (!clientWindowRenderingModeEnabled) throw throwable;
                if (clientWindow == null) throw throwable;
                ((ClientWindow)clientWindow).enableClientWindowRenderMode(context);
                throw throwable;
            }
            clientWindow.enableClientWindowRenderMode(context);
        }
        if (outcomeTarget.getFragment() == null) return url;
        return url + "#" + outcomeTarget.getFragment();
    }
}

