/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.faces.FacesException;
import javax.servlet.http.Part;
import org.primefaces.model.UploadedFile;

public class NativeUploadedFile
implements UploadedFile,
Serializable {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private Part part;
    private String filename;
    private byte[] cachedContent;

    public NativeUploadedFile() {
    }

    public NativeUploadedFile(Part part) {
        this.part = part;
        this.filename = this.resolveFilename(part);
    }

    public String getFileName() {
        return this.filename;
    }

    public InputStream getInputstream() throws IOException {
        return this.part.getInputStream();
    }

    public long getSize() {
        return this.part.getSize();
    }

    public byte[] getContents() {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        InputStream input = null;
        try {
            input = this.getInputstream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            this.cachedContent = output.toByteArray();
        }
        catch (IOException ex) {
            this.cachedContent = null;
            throw new FacesException((Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return this.cachedContent;
    }

    public String getContentType() {
        return this.part.getContentType();
    }

    private String resolveFilename(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            return cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
        }
        return null;
    }

    public void write(String filePath) throws Exception {
        this.part.write(filePath);
    }
}

