/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.UIData;
import org.primefaces.component.datalist.DataList;
import org.primefaces.component.datalist.DataListRenderer;
import org.primefaces.mobile.renderkit.paginator.PaginatorRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class DataListRenderer
extends org.primefaces.component.datalist.DataListRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataList list = (DataList)component;
        if (list.isPaginationRequest(context)) {
            list.updatePaginationData(context, list);
            if (list.isLazy()) {
                list.loadLazyData();
            }
            this.encodeList(context, list);
        } else {
            this.encodeMarkup(context, list);
            this.encodeScript(context, list);
        }
    }

    protected void encodeScript(FacesContext context, DataList list) throws IOException {
        String clientId = list.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DataList", list.resolveWidgetVar(), clientId);
        if (list.isPaginator()) {
            PaginatorRenderer paginatorRenderer = this.getPaginatorRenderer(context);
            paginatorRenderer.encodeScript(context, list, wb);
        }
        this.encodeClientBehaviors(context, list);
        wb.finish();
    }

    public void encodeMarkup(FacesContext context, DataList list) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = list.getClientId(context);
        String style = list.getStyle();
        String styleClass = list.getStyleClass();
        styleClass = styleClass == null ? "ui-datalist ui-widget" : "ui-datalist ui-widget " + styleClass;
        boolean hasPaginator = list.isPaginator();
        String paginatorPosition = list.getPaginatorPosition();
        PaginatorRenderer paginatorRenderer = this.getPaginatorRenderer(context);
        if (hasPaginator) {
            list.calculateFirst();
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeFacet(context, list, "header");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("bottom")) {
            paginatorRenderer.encodeMarkup(context, list, "top");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datalist-content", null);
        this.encodeList(context, list);
        writer.endElement("div");
        if (hasPaginator && !paginatorPosition.equalsIgnoreCase("top")) {
            paginatorRenderer.encodeMarkup(context, list, "bottom");
        }
        this.encodeFacet(context, list, "footer");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, DataList list) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int first = list.getFirst();
        int rows = list.getRows() == 0 ? list.getRowCount() : list.getRows();
        int pageSize = first + rows;
        int rowCount = list.getRowCount();
        String varStatus = list.getVarStatus();
        Map requestMap = context.getExternalContext().getRequestMap();
        String listTag = list.getListTag();
        writer.startElement(listTag, null);
        writer.writeAttribute("id", (Object)(list.getClientId(context) + "_list"), "id");
        if (list.getItemType() != null) {
            writer.writeAttribute("type", (Object)list.getItemType(), null);
        }
        this.renderDynamicPassThruAttributes(context, (UIComponent)list);
        for (int i = first; i < pageSize; ++i) {
            if (varStatus != null) {
                requestMap.put(varStatus, new DataListRenderer.VarStatus(first, pageSize - 1, i == 0, i == rowCount - 1, i, i % 2 == 0, i % 2 == 1, 1));
            }
            list.setRowIndex(i);
            if (!list.isRowAvailable()) continue;
            writer.startElement("li", null);
            this.renderChildren(context, (UIComponent)list);
            writer.endElement("li");
        }
        list.setRowIndex(-1);
        if (varStatus != null) {
            requestMap.remove(varStatus);
        }
        writer.endElement(listTag);
    }

    public void encodeFacet(FacesContext context, UIData data, String facet) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent component = data.getFacet(facet);
        if (component != null && component.isRendered()) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-bar ui-bar-b", null);
            writer.writeAttribute("role", (Object)"heading", null);
            component.encodeAll(context);
            writer.endElement("div");
        }
    }

    private PaginatorRenderer getPaginatorRenderer(FacesContext context) {
        PaginatorRenderer renderer = ComponentUtils.getUnwrappedRenderer(context, "org.primefaces.component", "org.primefaces.component.PaginatorRenderer", PaginatorRenderer.class);
        return renderer;
    }
}

