/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.AjaxSource;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.mobile.util.MobileUtils;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.util.ComponentTraversalUtils;

public abstract class BaseMenuRenderer
extends org.primefaces.component.menu.BaseMenuRenderer {
    protected void encodeMenuItem(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String title = menuitem.getTitle();
        boolean disabled = menuitem.isDisabled();
        String styleClass = this.getLinkStyleClass(menuitem);
        if (disabled) {
            styleClass = styleClass + " ui-state-disabled";
        }
        writer.startElement("a", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (this.shouldRenderId(menuitem)) {
            writer.writeAttribute("id", (Object)menuitem.getClientId(), null);
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        if (menuitem.getStyle() != null) {
            writer.writeAttribute("style", (Object)menuitem.getStyle(), null);
        }
        if (disabled) {
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)"return false;", null);
        } else {
            String url = menuitem.getUrl();
            String outcome = menuitem.getOutcome();
            String onclick = menuitem.getOnclick();
            if (url != null || outcome != null) {
                if (outcome != null && outcome.startsWith("pm:")) {
                    String command = MobileUtils.buildNavigation(outcome) + "return false;";
                    onclick = onclick == null ? command : onclick + ";" + command;
                    writer.writeAttribute("href", (Object)"#", null);
                } else {
                    String targetURL = this.getTargetURL(context, (UIOutcomeTarget)((Object)menuitem));
                    writer.writeAttribute("href", (Object)targetURL, null);
                    if (menuitem.getTarget() != null) {
                        writer.writeAttribute("target", (Object)menuitem.getTarget(), null);
                    }
                }
            } else {
                String command;
                writer.writeAttribute("href", (Object)"#", null);
                UIForm form = ComponentTraversalUtils.closestForm(context, (UIComponent)menu);
                if (form == null) {
                    throw new FacesException("MenuItem must be inside a form element.");
                }
                if (menuitem.isDynamic()) {
                    String menuClientId = menu.getClientId(context);
                    Map<String, List<String>> params = menuitem.getParams();
                    if (params == null) {
                        params = new LinkedHashMap<String, List<String>>();
                    }
                    ArrayList<String> idParams = new ArrayList<String>();
                    idParams.add(menuitem.getId());
                    params.put(menuClientId + "_menuid", idParams);
                    command = menuitem.isAjax() ? this.buildAjaxRequest(context, menu, (AjaxSource)((Object)menuitem), (UIComponent)form, params) : this.buildNonAjaxRequest(context, (UIComponent)menu, (UIComponent)form, menuClientId, params, true);
                } else {
                    command = menuitem.isAjax() ? this.buildAjaxRequest(context, (AjaxSource)((Object)menuitem), (UIComponent)form) : this.buildNonAjaxRequest(context, (UIComponent)menuitem, (UIComponent)form, ((UIComponent)menuitem).getClientId(context), true);
                }
                String string = onclick = onclick == null ? command : onclick + ";" + command;
            }
            if (onclick != null) {
                writer.writeAttribute("onclick", (Object)onclick, null);
            }
        }
        Object value = menuitem.getValue();
        if (value != null) {
            writer.writeText(value, null);
        }
        writer.endElement("a");
    }
}

