/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.context;

import java.lang.reflect.Method;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;

public class PrimeExternalContext
extends ExternalContextWrapper {
    private ExternalContext wrapped;
    private HttpServletRequest httpServletRequest;

    public PrimeExternalContext(ExternalContext wrapped) {
        this.wrapped = wrapped;
        this.extractHttpServletRequest();
    }

    public ExternalContext getWrapped() {
        return this.wrapped;
    }

    public String getRemoteAddr() {
        return this.httpServletRequest.getRemoteAddr();
    }

    protected void extractHttpServletRequest() {
        Object request = this.wrapped.getRequest();
        if (request instanceof HttpServletRequest) {
            this.httpServletRequest = (HttpServletRequest)request;
        } else if (this.isLiferay()) {
            try {
                Class<?> portletRequestClass = Class.forName("javax.portlet.PortletRequest");
                Class<?> portalUtilClass = Class.forName("com.liferay.portal.util.PortalUtil");
                Method method = portalUtilClass.getMethod("getHttpServletRequest", portletRequestClass);
                this.httpServletRequest = (HttpServletRequest)method.invoke(null, request);
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
        }
    }

    protected boolean isLiferay() {
        try {
            Class.forName("com.liferay.portal.util.PortalUtil");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static PrimeExternalContext getCurrentInstance(FacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        while (externalContext != null) {
            if (externalContext instanceof PrimeExternalContext) {
                return (PrimeExternalContext)externalContext;
            }
            if (externalContext instanceof ExternalContextWrapper) {
                externalContext = ((ExternalContextWrapper)externalContext).getWrapped();
                continue;
            }
            return null;
        }
        return null;
    }
}

