/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.row.Row;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.context.RequestContext;
import org.primefaces.model.SortOrder;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeComparator;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.RendererUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.TreeUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.visit.ResetInputVisitCallback;

public class TreeTableRenderer
extends CoreRenderer {
    private static final String SB_DECODE_SELECTION = TreeTableRenderer.class.getName() + "#decodeSelection";

    public void decode(FacesContext context, UIComponent component) {
        TreeTable tt = (TreeTable)component;
        if (tt.getSelectionMode() != null) {
            this.decodeSelection(context, tt);
        }
        if (tt.isSortRequest(context)) {
            this.decodeSort(context, tt);
        }
        this.decodeBehaviors(context, component);
    }

    protected void decodeSelection(FacesContext context, TreeTable tt) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String selectionMode = tt.getSelectionMode();
        String clientId = tt.getClientId(context);
        if (selectionMode != null) {
            String selectionValue = (String)params.get(tt.getClientId(context) + "_selection");
            boolean isSingle = selectionMode.equalsIgnoreCase("single");
            if (this.isValueBlank(selectionValue)) {
                if (isSingle) {
                    tt.setSelection(null);
                } else {
                    tt.setSelection(new TreeNode[0]);
                }
            } else {
                String[] selectedRowKeys = selectionValue.split(",");
                if (isSingle) {
                    tt.setRowKey(selectedRowKeys[0]);
                    tt.setSelection(tt.getRowNode());
                } else {
                    ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                    for (int i = 0; i < selectedRowKeys.length; ++i) {
                        tt.setRowKey(selectedRowKeys[i]);
                        TreeNode rowNode = tt.getRowNode();
                        if (rowNode == null) continue;
                        selectedNodes.add(rowNode);
                    }
                    tt.setSelection(selectedNodes.toArray(new TreeNode[selectedNodes.size()]));
                }
                tt.setRowKey(null);
            }
        }
        if (tt.isCheckboxSelection() && tt.isSelectionRequest(context)) {
            String selectedNodeRowKey = (String)params.get(clientId + "_instantSelection");
            tt.setRowKey(selectedNodeRowKey);
            TreeNode selectedNode = tt.getRowNode();
            ArrayList<String> descendantRowKeys = new ArrayList<String>();
            tt.populateRowKeys(selectedNode, descendantRowKeys);
            int size = descendantRowKeys.size();
            StringBuilder sb = SharedStringBuilder.get(context, SB_DECODE_SELECTION);
            for (int i = 0; i < size; ++i) {
                sb.append((String)descendantRowKeys.get(i));
                if (i == size - 1) continue;
                sb.append(",");
            }
            RequestContext.getCurrentInstance().addCallbackParam("descendantRowKeys", sb.toString());
            sb.setLength(0);
            descendantRowKeys = null;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TreeTable tt = (TreeTable)component;
        String clientId = tt.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        this.preRender(context, tt);
        String nodeKey = (String)params.get(clientId + "_expand");
        if (nodeKey != null) {
            tt.setRowKey(nodeKey);
            TreeNode node = tt.getRowNode();
            node.setExpanded(true);
            if (tt.getExpandMode().equals("self")) {
                this.encodeNode(context, tt, node);
            } else {
                this.encodeNodeChildren(context, tt, node);
            }
        } else if (tt.isSortRequest(context)) {
            this.encodeSort(context, tt);
        } else if (tt.isRowEditRequest(context)) {
            this.encodeRowEdit(context, tt);
        } else if (tt.isCellEditRequest(context)) {
            this.encodeCellEdit(context, tt);
        } else {
            this.encodeMarkup(context, tt);
            this.encodeScript(context, tt);
        }
    }

    protected void preRender(FacesContext context, TreeTable tt) {
        Columns dynamicCols = tt.getDynamicColumns();
        if (dynamicCols != null) {
            dynamicCols.setRowIndex(-1);
        }
    }

    protected void encodeScript(FacesContext context, TreeTable tt) throws IOException {
        String clientId = tt.getClientId(context);
        String selectionMode = tt.getSelectionMode();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("TreeTable", tt.resolveWidgetVar(), clientId).attr("selectionMode", selectionMode, null).attr("resizableColumns", tt.isResizableColumns(), false).attr("liveResize", tt.isLiveResize(), false).attr("scrollable", tt.isScrollable(), false).attr("scrollHeight", tt.getScrollHeight(), null).attr("scrollWidth", tt.getScrollWidth(), null).attr("nativeElements", tt.isNativeElements(), false).attr("expandMode", tt.getExpandMode(), "children");
        if (tt.isStickyHeader()) {
            wb.attr("stickyHeader", true);
        }
        if (tt.isEditable()) {
            wb.attr("editable", true).attr("editMode", tt.getEditMode()).attr("cellSeparator", tt.getCellSeparator(), null);
        }
        this.encodeClientBehaviors(context, tt);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tt.getClientId(context);
        boolean scrollable = tt.isScrollable();
        TreeNode root = tt.getValue();
        if (root.getRowKey() == null) {
            root.setRowKey("root");
            tt.buildRowKeys(root);
            tt.initPreselection();
        }
        if (tt.getValueExpression("sortBy") != null && !tt.isDefaultSorted()) {
            this.sort(tt);
        }
        String containerClass = tt.isResizableColumns() ? "ui-treetable ui-treetable-resizable ui-widget" : "ui-treetable ui-widget";
        containerClass = scrollable ? containerClass + " " + "ui-treetable-scrollable" : containerClass;
        containerClass = tt.getStyleClass() == null ? containerClass : containerClass + " " + tt.getStyleClass();
        containerClass = tt.isShowUnselectableCheckbox() ? containerClass + " ui-treetable-checkbox-all" : containerClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)containerClass, null);
        if (tt.getStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getStyle(), null);
        }
        if (scrollable) {
            this.encodeScrollableMarkup(context, tt);
        } else {
            this.encodeRegularMarkup(context, tt);
        }
        if (tt.getSelectionMode() != null) {
            this.encodeStateHolder(context, tt, clientId + "_selection", tt.getSelectedRowKeysAsString());
        }
        if (scrollable) {
            this.encodeStateHolder(context, tt, clientId + "_scrollState", tt.getScrollState());
        }
        writer.endElement("div");
    }

    protected void encodeScrollableMarkup(FacesContext context, TreeTable tt) throws IOException {
        String tableStyle = tt.getTableStyle();
        String tableStyleClass = tt.getTableStyleClass();
        this.encodeScrollAreaStart(context, tt, "ui-widget-header ui-treetable-scrollable-header", "ui-treetable-scrollable-header-box", tableStyle, tableStyleClass, "header", "ui-treetable-header ui-widget-header ui-corner-top");
        this.encodeThead(context, tt);
        this.encodeScrollAreaEnd(context);
        this.encodeScrollBody(context, tt, tableStyle, tableStyleClass);
        this.encodeScrollAreaStart(context, tt, "ui-widget-header ui-treetable-scrollable-footer", "ui-treetable-scrollable-footer-box", tableStyle, tableStyleClass, "footer", "ui-treetable-footer ui-widget-header ui-corner-bottom");
        this.encodeTfoot(context, tt);
        this.encodeScrollAreaEnd(context);
    }

    protected void encodeScrollBody(FacesContext context, TreeTable tt, String tableStyle, String tableStyleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String scrollHeight = tt.getScrollHeight();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-treetable-scrollable-body", null);
        if (scrollHeight != null && scrollHeight.indexOf(37) == -1) {
            writer.writeAttribute("style", (Object)("height:" + scrollHeight + "px"), null);
        }
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
        this.encodeTbody(context, tt, false);
        writer.endElement("table");
        writer.endElement("div");
    }

    protected void encodeScrollAreaStart(FacesContext context, TreeTable tt, String containerClass, String containerBoxClass, String tableStyle, String tableStyleClass, String facet, String facetClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerClass, null);
        this.encodeFacet(context, tt, tt.getFacet(facet), facetClass);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)containerBoxClass, null);
        writer.startElement("table", null);
        writer.writeAttribute("role", (Object)"grid", null);
        if (tableStyle != null) {
            writer.writeAttribute("style", (Object)tableStyle, null);
        }
        if (tableStyleClass != null) {
            writer.writeAttribute("class", (Object)tableStyleClass, null);
        }
    }

    protected void encodeScrollAreaEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeRegularMarkup(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        this.encodeFacet(context, tt, tt.getFacet("header"), "ui-treetable-header ui-widget-header ui-corner-top");
        writer.startElement("table", (UIComponent)tt);
        writer.writeAttribute("role", (Object)"treegrid", null);
        if (tt.getTableStyle() != null) {
            writer.writeAttribute("style", (Object)tt.getTableStyle(), null);
        }
        if (tt.getTableStyleClass() != null) {
            writer.writeAttribute("class", (Object)tt.getTableStyleClass(), null);
        }
        this.encodeThead(context, tt);
        this.encodeTfoot(context, tt);
        this.encodeTbody(context, tt, false);
        writer.endElement("table");
        this.encodeFacet(context, tt, tt.getFacet("footer"), "ui-treetable-footer ui-widget-header ui-corner-bottom");
    }

    protected void encodeThead(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = tt.getColumnGroup("header");
        String clientId = tt.getClientId(context);
        writer.startElement("thead", null);
        writer.writeAttribute("id", (Object)(clientId + "_head"), null);
        if (group != null && group.isRendered()) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row headerRow = (Row)child;
                String rowClass = headerRow.getStyleClass();
                String rowStyle = headerRow.getStyle();
                writer.startElement("tr", null);
                if (rowClass != null) {
                    writer.writeAttribute("class", (Object)rowClass, null);
                }
                if (rowStyle != null) {
                    writer.writeAttribute("style", (Object)rowStyle, null);
                }
                for (UIComponent headerRowChild : headerRow.getChildren()) {
                    if (!headerRowChild.isRendered() || !(headerRowChild instanceof Column)) continue;
                    this.encodeColumnHeader(context, tt, (Column)headerRowChild);
                }
                writer.endElement("tr");
            }
        } else {
            writer.startElement("tr", null);
            writer.writeAttribute("role", (Object)"row", null);
            List<UIColumn> columns = tt.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof Column) {
                    this.encodeColumnHeader(context, tt, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                this.encodeColumnHeader(context, tt, dynamicColumn);
            }
            writer.endElement("tr");
        }
        writer.endElement("thead");
    }

    protected void encodeTbody(FacesContext context, TreeTable tt, boolean dataOnly) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TreeNode root = tt.getValue();
        String clientId = tt.getClientId(context);
        boolean empty = root == null || root.getChildCount() == 0;
        UIComponent emptyFacet = tt.getFacet("emptyMessage");
        if (!dataOnly) {
            writer.startElement("tbody", null);
            writer.writeAttribute("id", (Object)(clientId + "_data"), null);
            writer.writeAttribute("class", (Object)"ui-treetable-data ui-widget-content", null);
        }
        if (empty) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-widget-content ui-treetable-empty-message", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)tt.getColumnsCount(), null);
            if (emptyFacet != null) {
                emptyFacet.encodeAll(context);
            } else {
                writer.write(tt.getEmptyMessage());
            }
            writer.endElement("td");
            writer.endElement("tr");
        }
        if (root != null) {
            this.encodeNodeChildren(context, tt, root);
        }
        tt.setRowKey(null);
        if (!dataOnly) {
            writer.endElement("tbody");
        }
    }

    protected void encodeNode(FacesContext context, TreeTable tt, TreeNode treeNode) throws IOException {
        String userRowStyleClass;
        ResponseWriter writer = context.getResponseWriter();
        String rowKey = treeNode.getRowKey();
        String parentRowKey = treeNode.getParent().getRowKey();
        tt.setRowKey(rowKey);
        String icon = treeNode.isExpanded() ? "ui-treetable-toggler ui-icon ui-icon-triangle-1-s ui-c" : "ui-treetable-toggler ui-icon ui-icon-triangle-1-e ui-c";
        int depth = rowKey.split("_").length - 1;
        String selectionMode = tt.getSelectionMode();
        boolean selectionEnabled = selectionMode != null;
        boolean selectable = treeNode.isSelectable() && selectionEnabled;
        boolean checkboxSelection = selectionEnabled && selectionMode.equals("checkbox");
        boolean selected = treeNode.isSelected();
        boolean partialSelected = treeNode.isPartialSelected();
        boolean nativeElements = tt.isNativeElements();
        List<UIColumn> columns = tt.getColumns();
        String rowStyleClass = selected ? "ui-widget-content ui-state-highlight ui-selected" : "ui-widget-content";
        rowStyleClass = selectable ? rowStyleClass + " " + "ui-treetable-selectable-node" : rowStyleClass;
        rowStyleClass = rowStyleClass + " " + treeNode.getType();
        if (partialSelected) {
            rowStyleClass = rowStyleClass + " " + "ui-treetable-partialselected";
        }
        if ((userRowStyleClass = tt.getRowStyleClass()) != null) {
            rowStyleClass = rowStyleClass + " " + userRowStyleClass;
        }
        if (tt.isEditingRow()) {
            rowStyleClass = rowStyleClass + " " + "ui-row-editing";
        }
        writer.startElement("tr", null);
        writer.writeAttribute("id", (Object)(tt.getClientId(context) + "_node_" + rowKey), null);
        writer.writeAttribute("class", (Object)rowStyleClass, null);
        writer.writeAttribute("role", (Object)"row", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(treeNode.isExpanded()), null);
        writer.writeAttribute("data-rk", (Object)rowKey, null);
        if (parentRowKey != null) {
            writer.writeAttribute("data-prk", (Object)parentRowKey, null);
        }
        if (selectionEnabled) {
            writer.writeAttribute("aria-selected", (Object)String.valueOf(selected), null);
        }
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            if (column.isDynamic()) {
                ((DynamicColumn)column).applyModel();
            }
            if (!column.isRendered()) continue;
            String columnStyleClass = column.getStyleClass();
            String columnStyle = column.getStyle();
            int rowspan = column.getRowspan();
            int colspan = column.getColspan();
            int priority = column.getPriority();
            if (priority > 0) {
                String string = columnStyleClass = columnStyleClass == null ? "ui-column-p-" + priority : columnStyleClass + " ui-column-p-" + priority;
            }
            if (column.getCellEditor() != null) {
                columnStyleClass = columnStyleClass == null ? "ui-editable-column" : "ui-editable-column " + columnStyleClass;
            }
            writer.startElement("td", null);
            writer.writeAttribute("role", (Object)"gridcell", null);
            if (columnStyle != null) {
                writer.writeAttribute("style", (Object)columnStyle, null);
            }
            if (columnStyleClass != null) {
                writer.writeAttribute("class", (Object)columnStyleClass, null);
            }
            if (rowspan != 1) {
                writer.writeAttribute("rowspan", (Object)rowspan, null);
            }
            if (colspan != 1) {
                writer.writeAttribute("colspan", (Object)colspan, null);
            }
            if (i == 0) {
                for (int j = 0; j < depth; ++j) {
                    writer.startElement("span", null);
                    writer.writeAttribute("class", (Object)"ui-treetable-indent", null);
                    writer.endElement("span");
                }
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)icon, null);
                if (treeNode.isLeaf()) {
                    writer.writeAttribute("style", (Object)"visibility:hidden", null);
                }
                writer.endElement("span");
                if (checkboxSelection) {
                    if (!nativeElements) {
                        RendererUtils.encodeCheckbox(context, selected, partialSelected, !selectable, "ui-selection");
                    } else {
                        this.renderNativeCheckbox(context, tt, selected, partialSelected);
                    }
                }
            }
            column.renderChildren(context);
            writer.endElement("td");
        }
        writer.endElement("tr");
        if (treeNode.isExpanded()) {
            this.encodeNodeChildren(context, tt, treeNode);
        }
    }

    protected void encodeColumnHeader(FacesContext context, TreeTable tt, UIColumn column) throws IOException {
        int priority;
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = column.getFacet("header");
        String headerText = column.getHeaderText();
        int colspan = column.getColspan();
        int rowspan = column.getRowspan();
        ValueExpression columnSortByVE = column.getValueExpression("sortBy");
        boolean sortable = columnSortByVE != null;
        String sortIcon = null;
        String style = column.getStyle();
        String columnClass = sortable ? "ui-state-default ui-sortable-column" : "ui-state-default";
        String userColumnClass = column.getStyleClass();
        if (column.isResizable()) {
            columnClass = columnClass + " " + "ui-resizable-column";
        }
        if (userColumnClass != null) {
            columnClass = columnClass + " " + userColumnClass;
        }
        if (sortable) {
            ValueExpression tableSortByVE = tt.getValueExpression("sortBy");
            if (tableSortByVE != null) {
                sortIcon = this.resolveSortIcon(columnSortByVE, tableSortByVE, tt.getSortOrder());
            }
            if (sortIcon == null) {
                sortIcon = "ui-sortable-column-icon ui-icon ui-icon-carat-2-n-s";
            } else {
                columnClass = columnClass + " ui-state-active";
            }
        }
        if ((priority = column.getPriority()) > 0) {
            columnClass = columnClass + " ui-column-p-" + priority;
        }
        writer.startElement("th", null);
        writer.writeAttribute("id", (Object)column.getContainerClientId(context), null);
        writer.writeAttribute("class", (Object)columnClass, null);
        writer.writeAttribute("role", (Object)"columnheader", null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (rowspan != 1) {
            writer.writeAttribute("rowspan", (Object)rowspan, null);
        }
        if (colspan != 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-column-title", null);
        if (header != null) {
            header.encodeAll(context);
        } else if (headerText != null) {
            writer.write(headerText);
        }
        writer.endElement("span");
        if (sortable) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)sortIcon, null);
            writer.endElement("span");
        }
        writer.endElement("th");
    }

    protected void encodeNodeChildren(FacesContext context, TreeTable tt, TreeNode treeNode) throws IOException {
        int childCount = treeNode.getChildCount();
        if (childCount > 0) {
            List<TreeNode> children = treeNode.getChildren();
            for (int i = 0; i < childCount; ++i) {
                this.encodeNode(context, tt, children.get(i));
            }
        }
    }

    protected void encodeFacet(FacesContext context, TreeTable tt, UIComponent facet, String styleClass) throws IOException {
        if (facet == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        facet.encodeAll(context);
        writer.endElement("div");
    }

    protected void encodeTfoot(FacesContext context, TreeTable tt) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ColumnGroup group = tt.getColumnGroup("footer");
        writer.startElement("tfoot", null);
        if (group != null && group.isRendered()) {
            for (UIComponent child : group.getChildren()) {
                if (!child.isRendered() || !(child instanceof Row)) continue;
                Row footerRow = (Row)child;
                String rowClass = footerRow.getStyleClass();
                String rowStyle = footerRow.getStyle();
                writer.startElement("tr", null);
                if (rowClass != null) {
                    writer.writeAttribute("class", (Object)rowClass, null);
                }
                if (rowStyle != null) {
                    writer.writeAttribute("style", (Object)rowStyle, null);
                }
                for (UIComponent footerRowChild : footerRow.getChildren()) {
                    if (!footerRowChild.isRendered() || !(footerRowChild instanceof Column)) continue;
                    this.encodeColumnFooter(context, tt, (Column)footerRowChild);
                }
                writer.endElement("tr");
            }
        } else if (tt.hasFooterColumn()) {
            writer.startElement("tr", null);
            List<UIColumn> columns = tt.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                UIColumn column = columns.get(i);
                if (column instanceof Column) {
                    this.encodeColumnFooter(context, tt, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                this.encodeColumnFooter(context, tt, dynamicColumn);
            }
            writer.endElement("tr");
        }
        writer.endElement("tfoot");
    }

    protected void encodeColumnFooter(FacesContext context, TreeTable table, UIColumn column) throws IOException {
        if (!column.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        int colspan = column.getColspan();
        int rowspan = column.getRowspan();
        UIComponent footerFacet = column.getFacet("footer");
        String footerText = column.getFooterText();
        String style = column.getStyle();
        String columnStyleClass = column.getStyleClass();
        columnStyleClass = columnStyleClass == null ? "ui-state-default" : "ui-state-default " + columnStyleClass;
        int priority = column.getPriority();
        if (priority > 0) {
            columnStyleClass = columnStyleClass + " ui-column-p-" + priority;
        }
        writer.startElement("td", null);
        writer.writeAttribute("class", (Object)columnStyleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (rowspan != 1) {
            writer.writeAttribute("rowspan", (Object)rowspan, null);
        }
        if (colspan != 1) {
            writer.writeAttribute("colspan", (Object)colspan, null);
        }
        if (footerFacet != null) {
            footerFacet.encodeAll(context);
        } else if (footerText != null) {
            writer.write(footerText);
        }
        writer.endElement("td");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void encodeStateHolder(FacesContext context, TreeTable tt, String name, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)name, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)value, null);
        writer.endElement("input");
    }

    protected String resolveSortIcon(ValueExpression columnSortBy, ValueExpression ttSortBy, String sortOrder) {
        String columnSortByExpression = columnSortBy.getExpressionString();
        String ttSortByExpression = ttSortBy.getExpressionString();
        String sortIcon = null;
        if (ttSortByExpression != null && ttSortByExpression.equals(columnSortByExpression)) {
            if (sortOrder.equalsIgnoreCase("ASCENDING")) {
                sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-n";
            } else if (sortOrder.equalsIgnoreCase("DESCENDING")) {
                sortIcon = "ui-sortable-column-icon ui-icon ui-icon ui-icon-carat-2-n-s ui-icon-triangle-1-s";
            }
        }
        return sortIcon;
    }

    protected void decodeSort(FacesContext context, TreeTable tt) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tt.getClientId(context);
        String sortKey = (String)params.get(clientId + "_sortKey");
        String sortDir = (String)params.get(clientId + "_sortDir");
        UIColumn sortColumn = tt.findColumn(sortKey);
        ValueExpression sortByVE = sortColumn.getValueExpression("sortBy");
        tt.setValueExpression("sortBy", sortByVE);
        tt.setSortColumn(sortColumn);
        tt.setSortFunction(sortColumn.getSortFunction());
        tt.setSortOrder(sortDir);
    }

    protected void encodeSort(FacesContext context, TreeTable tt) throws IOException {
        this.sort(tt);
        this.encodeTbody(context, tt, true);
    }

    public void sort(TreeTable tt) {
        TreeNode root = tt.getValue();
        if (root == null) {
            return;
        }
        UIColumn sortColumn = tt.getSortColumn();
        if (sortColumn != null && sortColumn.isDynamic()) {
            ((DynamicColumn)sortColumn).applyStatelessModel();
        }
        ValueExpression sortByVE = tt.getValueExpression("sortBy");
        SortOrder sortOrder = SortOrder.valueOf(tt.getSortOrder().toUpperCase(Locale.ENGLISH));
        TreeUtils.sortNode(root, new TreeNodeComparator(sortByVE, tt.getVar(), sortOrder, tt.getSortFunction(), tt.isCaseSensitiveSort(), tt.resolveDataLocale()));
        tt.updateRowKeys(root);
        RequestContext requestContext = RequestContext.getCurrentInstance();
        requestContext.addCallbackParam("selection", tt.getSelectedRowKeysAsString());
    }

    protected void renderNativeCheckbox(FacesContext context, TreeTable tt, boolean checked, boolean partialSelected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"checkbox", null);
        writer.writeAttribute("name", (Object)(tt.getContainerClientId(context) + "_checkbox"), null);
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (partialSelected) {
            writer.writeAttribute("class", (Object)"ui-treetable-indeterminate", null);
        }
        writer.endElement("input");
    }

    public void encodeRowEdit(FacesContext context, TreeTable tt) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tt.getClientId(context);
        String editedRowKey = (String)params.get(clientId + "_rowEditIndex");
        String action = (String)params.get(clientId + "_rowEditAction");
        tt.setRowKey(editedRowKey);
        TreeNode node = tt.getRowNode();
        if (action.equals("cancel")) {
            VisitContext visitContext = null;
            for (UIColumn column : tt.getColumns()) {
                for (UIComponent grandkid : column.getChildren()) {
                    if (!(grandkid instanceof CellEditor)) continue;
                    UIComponent inputFacet = grandkid.getFacet("input");
                    if (inputFacet instanceof EditableValueHolder) {
                        ((EditableValueHolder)inputFacet).resetValue();
                        continue;
                    }
                    if (visitContext == null) {
                        visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
                    }
                    inputFacet.visitTree(visitContext, (VisitCallback)ResetInputVisitCallback.INSTANCE);
                }
            }
        }
        this.encodeNode(context, tt, node);
    }

    public void encodeCellEdit(FacesContext context, TreeTable tt) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = tt.getClientId(context);
        String[] cellInfo = ((String)params.get(clientId + "_cellInfo")).split(",");
        String rowKey = cellInfo[0];
        int cellIndex = Integer.parseInt(cellInfo[1]);
        int i = -1;
        UIColumn column = null;
        for (UIColumn col : tt.getColumns()) {
            if (!col.isRendered() || ++i != cellIndex) continue;
            column = col;
            break;
        }
        tt.setRowKey(rowKey);
        if (column.isDynamic()) {
            DynamicColumn dynamicColumn = (DynamicColumn)column;
            dynamicColumn.applyStatelessModel();
        }
        column.getCellEditor().getFacet("output").encodeAll(context);
        if (column.isDynamic()) {
            ((DynamicColumn)column).cleanStatelessModel();
        }
    }
}

