/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.selectoneradio;

import java.io.IOException;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import javax.faces.render.Renderer;
import org.primefaces.component.radiobutton.RadioButton;
import org.primefaces.component.selectoneradio.SelectOneRadio;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.SelectOneRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.GridLayoutUtils;
import org.primefaces.util.WidgetBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectOneRadioRenderer
extends SelectOneRenderer {
    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Renderer renderer = ComponentUtils.getUnwrappedRenderer(context, "javax.faces.SelectOne", "javax.faces.Radio", Renderer.class);
        return renderer.getConvertedValue(context, component, submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SelectOneRadio radio = (SelectOneRadio)component;
        this.encodeMarkup(context, radio);
        this.encodeScript(context, radio);
    }

    protected void encodeMarkup(FacesContext context, SelectOneRadio radio) throws IOException {
        boolean custom;
        ResponseWriter writer = context.getResponseWriter();
        String layout = radio.getLayout();
        if (layout == null) {
            layout = "lineDirection";
        }
        if (custom = layout.equals("custom")) {
            writer.startElement("span", (UIComponent)radio);
            writer.writeAttribute("id", (Object)radio.getClientId(context), "id");
            writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
            this.encodeCustomLayout(context, radio);
            writer.endElement("span");
        } else if (layout.equals("responsive")) {
            this.encodeResponsiveLayout(context, radio);
        } else {
            this.encodeTabularLayout(context, radio, layout);
        }
    }

    protected void encodeScript(FacesContext context, SelectOneRadio radio) throws IOException {
        String clientId = radio.getClientId(context);
        String layout = radio.getLayout();
        boolean custom = layout != null && layout.equals("custom");
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("SelectOneRadio", radio.resolveWidgetVar(), clientId).attr("custom", custom, false).finish();
    }

    protected void encodeResponsiveLayout(FacesContext context, SelectOneRadio radio) throws IOException {
        Class type;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = radio.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)radio);
        String style = radio.getStyle();
        String styleClass = radio.getStyleClass();
        String defaultStyleClass = radio.isPlain() ? "ui-selectoneradio ui-selectoneradio-native ui-widget" : "ui-selectoneradio ui-widget";
        defaultStyleClass = defaultStyleClass + " ui-grid ui-grid-responsive";
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        writer.startElement("div", (UIComponent)radio);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        Converter converter = radio.getConverter();
        String name = radio.getClientId(context);
        Object value = radio.getSubmittedValue();
        int columns = radio.getColumns();
        if (value == null) {
            value = radio.getValue();
        }
        Class clazz = type = value == null ? String.class : value.getClass();
        if (columns > 0) {
            int idx = 0;
            for (SelectItem selectItem : selectItems) {
                boolean disabled = selectItem.isDisabled() || radio.isDisabled();
                String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
                Object coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type);
                boolean selected = coercedItemValue != null && coercedItemValue.equals(value);
                int colMod = idx % columns;
                if (colMod == 0) {
                    writer.startElement("div", null);
                    writer.writeAttribute("class", (Object)"ui-grid-row", null);
                }
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)GridLayoutUtils.getColumnClass(columns), null);
                this.encodeOption(context, radio, selectItem, id, name, converter, selected, disabled);
                writer.endElement("div");
                if ((colMod = ++idx % columns) != 0) continue;
                writer.endElement("div");
            }
            if (idx != 0 && idx % columns != 0) {
                writer.endElement("div");
            }
        } else {
            throw new FacesException("The value of columns attribute must be greater than zero.");
        }
        writer.endElement("div");
    }

    protected void encodeTabularLayout(FacesContext context, SelectOneRadio radio, String layout) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = radio.getClientId(context);
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)radio);
        String style = radio.getStyle();
        String styleClass = radio.getStyleClass();
        String defaultStyleClass = radio.isPlain() ? "ui-selectoneradio ui-selectoneradio-native ui-widget" : "ui-selectoneradio ui-widget";
        styleClass = styleClass == null ? defaultStyleClass : defaultStyleClass + " " + styleClass;
        writer.startElement("table", (UIComponent)radio);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("role", (Object)"presentation", null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeSelectItems(context, radio, selectItems, layout);
        writer.endElement("table");
    }

    protected void encodeSelectItems(FacesContext context, SelectOneRadio radio, List<SelectItem> selectItems, String layout) throws IOException {
        if (layout.equals("lineDirection")) {
            this.encodeLineLayout(context, radio, selectItems);
        } else if (layout.equals("pageDirection")) {
            this.encodePageLayout(context, radio, selectItems);
        } else if (layout.equals("grid")) {
            this.encodeGridLayout(context, radio, selectItems);
        } else {
            throw new FacesException("Invalid '" + layout + "' type for component '" + radio.getClientId(context) + "'.");
        }
    }

    protected void encodeCustomLayout(FacesContext context, SelectOneRadio radio) throws IOException {
        Converter converter = radio.getConverter();
        String name = radio.getClientId(context);
        Object value = radio.getSubmittedValue();
        List<SelectItem> selectItems = this.getSelectItems(context, (UIInput)radio);
        if (value == null) {
            value = radio.getValue();
        }
        Class type = value == null ? String.class : value.getClass();
        int idx = 0;
        for (SelectItem selectItem : selectItems) {
            String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
            Object coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type);
            boolean selected = coercedItemValue != null && coercedItemValue.equals(value);
            String itemValueAsString = this.getOptionAsString(context, (UIComponent)radio, converter, selectItem.getValue());
            this.encodeOptionInput(context, radio, id, name, selected, true, itemValueAsString);
            ++idx;
        }
    }

    protected void encodeLineLayout(FacesContext context, SelectOneRadio radio, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = radio.getConverter();
        String name = radio.getClientId(context);
        Object value = radio.getSubmittedValue();
        if (value == null) {
            value = radio.getValue();
        }
        Class type = value == null ? String.class : value.getClass();
        writer.startElement("tr", null);
        int idx = 0;
        for (SelectItem selectItem : selectItems) {
            boolean disabled = selectItem.isDisabled() || radio.isDisabled();
            String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
            Object coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type);
            boolean selected = coercedItemValue != null && coercedItemValue.equals(value);
            this.encodeOption(context, radio, selectItem, id, name, converter, selected, disabled);
            ++idx;
        }
        writer.endElement("tr");
    }

    protected void encodePageLayout(FacesContext context, SelectOneRadio radio, List<SelectItem> selectItems) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = radio.getConverter();
        String name = radio.getClientId(context);
        Object value = radio.getSubmittedValue();
        if (value == null) {
            value = radio.getValue();
        }
        Class type = value == null ? String.class : value.getClass();
        int idx = 0;
        for (SelectItem selectItem : selectItems) {
            boolean disabled = selectItem.isDisabled() || radio.isDisabled();
            String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
            Object coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type);
            boolean selected = coercedItemValue != null && coercedItemValue.equals(value);
            writer.startElement("tr", null);
            this.encodeOption(context, radio, selectItem, id, name, converter, selected, disabled);
            writer.endElement("tr");
            ++idx;
        }
    }

    protected void encodeGridLayout(FacesContext context, SelectOneRadio radio, List<SelectItem> selectItems) throws IOException {
        Class type;
        ResponseWriter writer = context.getResponseWriter();
        Converter converter = radio.getConverter();
        String name = radio.getClientId(context);
        Object value = radio.getSubmittedValue();
        int columns = radio.getColumns();
        if (value == null) {
            value = radio.getValue();
        }
        Class clazz = type = value == null ? String.class : value.getClass();
        if (columns > 0) {
            int idx = 0;
            for (SelectItem selectItem : selectItems) {
                boolean disabled = selectItem.isDisabled() || radio.isDisabled();
                String id = name + UINamingContainer.getSeparatorChar((FacesContext)context) + idx;
                Object coercedItemValue = this.coerceToModelType(context, selectItem.getValue(), type);
                boolean selected = coercedItemValue != null && coercedItemValue.equals(value);
                int colMod = idx % columns;
                if (colMod == 0) {
                    writer.startElement("tr", null);
                }
                this.encodeOption(context, radio, selectItem, id, name, converter, selected, disabled);
                if ((colMod = ++idx % columns) != 0) continue;
                writer.endElement("tr");
            }
        } else {
            throw new FacesException("The value of columns attribute must be greater than zero.");
        }
    }

    protected void encodeResponsiveItems(FacesContext context, SelectOneRadio radio, List<SelectItem> selectItems) throws IOException {
    }

    protected void encodeOption(FacesContext context, SelectOneRadio radio, SelectItem option, String id, String name, Converter converter, boolean selected, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String itemValueAsString = this.getOptionAsString(context, (UIComponent)radio, converter, option.getValue());
        String styleClass = radio.isPlain() ? "ui-radiobutton ui-radiobutton-native ui-widget" : "ui-radiobutton ui-widget";
        writer.startElement("td", null);
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        this.encodeOptionInput(context, radio, id, name, selected, disabled, itemValueAsString);
        this.encodeOptionOutput(context, radio, selected, disabled);
        writer.endElement("div");
        writer.endElement("td");
        writer.startElement("td", null);
        this.encodeOptionLabel(context, radio, id, option, disabled);
        writer.endElement("td");
    }

    protected void encodeOptionInput(FacesContext context, SelectOneRadio radio, String id, String name, boolean checked, boolean disabled, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)name, null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("value", (Object)value, null);
        this.renderDomEvents(context, (UIComponent)radio, SelectOneRadio.SUPPORTED_EVENTS);
        if (radio.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)radio.getTabindex(), null);
        }
        if (checked) {
            writer.writeAttribute("checked", (Object)"checked", null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (RequestContext.getCurrentInstance().getApplicationContext().getConfig().isClientSideValidationEnabled()) {
            this.renderValidationMetadata(context, (EditableValueHolder)radio);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected void encodeOptionLabel(FacesContext context, SelectOneRadio radio, String containerClientId, SelectItem option, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = option.getLabel();
        writer.startElement("label", null);
        writer.writeAttribute("for", (Object)containerClientId, null);
        if (disabled) {
            writer.writeAttribute("class", (Object)"ui-state-disabled", null);
        }
        if (label != null) {
            if (option.isEscape()) {
                writer.writeText((Object)label, null);
            } else {
                writer.write(label);
            }
        }
        writer.endElement("label");
    }

    protected void encodeOptionOutput(FacesContext context, SelectOneRadio radio, boolean selected, boolean disabled) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String boxClass = "ui-radiobutton-box ui-widget ui-corner-all ui-state-default";
        boxClass = selected ? boxClass + " ui-state-active" : boxClass;
        boxClass = disabled ? boxClass + " ui-state-disabled" : boxClass;
        boxClass = !radio.isValid() ? boxClass + " ui-state-error" : boxClass;
        String iconClass = selected ? "ui-radiobutton-icon ui-icon ui-icon-bullet ui-c" : "ui-radiobutton-icon ui-icon ui-icon-blank ui-c";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("div");
    }

    protected void encodeRadioButton(FacesContext context, SelectOneRadio radio, RadioButton button) throws IOException {
    }

    protected Class getValueType(FacesContext context, UIInput input) {
        ValueExpression ve = input.getValueExpression("value");
        Class type = ve == null ? String.class : ve.getType(context.getELContext());
        return type == null ? String.class : type;
    }

    @Override
    protected String getSubmitParam(FacesContext context, UISelectOne selectOne) {
        return selectOne.getClientId(context);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public String getHighlighter() {
        return "oneradio";
    }

    @Override
    protected boolean isGrouped() {
        return true;
    }
}

