/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.resetinput;

import java.io.Serializable;
import java.util.List;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;
import org.primefaces.visit.ResetInputVisitCallback;

public class ResetInputActionListener
implements ActionListener,
Serializable {
    private ValueExpression target;
    private ValueExpression clearModel;

    public ResetInputActionListener() {
    }

    public ResetInputActionListener(ValueExpression target, ValueExpression clearModel) {
        this.target = target;
        this.clearModel = clearModel;
    }

    public void processAction(ActionEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, ComponentUtils.VISIT_HINTS_SKIP_UNRENDERED);
        String expressions = (String)this.target.getValue(elContext);
        boolean resetModel = false;
        if (this.clearModel != null) {
            resetModel = this.clearModel.isLiteralText() ? Boolean.valueOf(this.clearModel.getValue(context.getELContext()).toString()) : (Boolean)this.clearModel.getValue(context.getELContext());
        }
        UIComponent source = event.getComponent();
        List<UIComponent> components = SearchExpressionFacade.resolveComponents(context, source, expressions, 8);
        for (UIComponent component : components) {
            component.visitTree(visitContext, (VisitCallback)new ResetInputVisitCallback(resetModel));
        }
    }
}

