/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.importenum;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.component.importenum.EnumHashMap;
import org.primefaces.context.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportEnumTagHandler
extends TagHandler {
    private static final String DEFAULT_ALL_SUFFIX = "ALL_VALUES";
    private final TagAttribute typeTagAttribute = super.getRequiredAttribute("type");
    private final TagAttribute varTagAttribute = super.getAttribute("var");
    private final TagAttribute allSuffixTagAttribute = super.getAttribute("allSuffix");

    public ImportEnumTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Class<?> type = this.getClassFromAttribute(this.typeTagAttribute, ctx);
        Map<String, Object> enumValues = this.getEnumValues(facesContext, type, this.allSuffixTagAttribute == null ? null : this.allSuffixTagAttribute.getValue(ctx));
        String var = this.varTagAttribute == null ? type.getSimpleName() : this.varTagAttribute.getValue(ctx);
        if (var.charAt(0) != '#') {
            StringBuilder varBuilder = new StringBuilder();
            varBuilder.append("#{").append(var).append("}");
            var = varBuilder.toString();
        }
        ELContext elContext = facesContext.getELContext();
        ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
        ValueExpression aliasValueExpression = expressionFactory.createValueExpression(elContext, var, Map.class);
        aliasValueExpression.setValue(elContext, enumValues);
    }

    protected Class<?> getClassFromAttribute(TagAttribute attribute, FaceletContext ctx) {
        String type = attribute.getValue(ctx);
        try {
            return Class.forName(type, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new FacesException("Class " + type + " not found.", (Throwable)e);
        }
    }

    protected Map<String, Object> getEnumValues(FacesContext facesContext, Class<?> type, String allSuffix) {
        if (type.isEnum()) {
            Map<Object, Object> enums;
            boolean cacheEnabled = facesContext.isProjectStage(ProjectStage.Production);
            Map<Class<?>, Map<String, Object>> cache = RequestContext.getCurrentInstance().getApplicationContext().getEnumCacheMap();
            if (cacheEnabled && cache.containsKey(type)) {
                enums = cache.get(type);
            } else {
                enums = new EnumHashMap(type);
                for (Object value : type.getEnumConstants()) {
                    Enum currentEnum = (Enum)value;
                    enums.put(currentEnum.name(), currentEnum);
                }
                if (allSuffix != null) {
                    enums.put(allSuffix, type.getEnumConstants());
                }
                enums.put(DEFAULT_ALL_SUFFIX, type.getEnumConstants());
                enums = Collections.unmodifiableMap(enums);
                if (cacheEnabled) {
                    cache.put(type, enums);
                }
            }
            return enums;
        }
        throw new FacesException("Class '" + type + "' is not an enum.");
    }
}

