/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.ExcelExportVisitCallback;
import org.primefaces.component.export.Exporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelExporter
extends Exporter {
    @Override
    public void export(FacesContext context, DataTable table, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        Workbook wb = this.createWorkBook();
        String sheetName = this.getSheetName(context, table);
        if (sheetName == null) {
            sheetName = table.getId();
        }
        Sheet sheet = wb.createSheet(sheetName);
        if (preProcessor != null) {
            preProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        this.exportTable(context, table, sheet, pageOnly, selectionOnly);
        if (postProcessor != null) {
            postProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        this.writeExcelToResponse(context.getExternalContext(), wb, filename);
    }

    @Override
    public void export(FacesContext context, String filename, List<DataTable> tables, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        Workbook wb = this.createWorkBook();
        if (preProcessor != null) {
            preProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        for (DataTable table : tables) {
            String sheetName = this.getSheetName(context, table);
            if (sheetName == null) {
                sheetName = table.getId();
            }
            Sheet sheet = wb.createSheet(sheetName);
            this.exportTable(context, table, sheet, pageOnly, selectionOnly);
        }
        if (postProcessor != null) {
            postProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        this.writeExcelToResponse(context.getExternalContext(), wb, filename);
    }

    @Override
    public void export(FacesContext context, List<String> clientIds, String filename, boolean pageOnly, boolean selectionOnly, String encodingType, MethodExpression preProcessor, MethodExpression postProcessor) throws IOException {
        Workbook wb = this.createWorkBook();
        if (preProcessor != null) {
            preProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, clientIds, null);
        ExcelExportVisitCallback visitCallback = new ExcelExportVisitCallback(this, wb, pageOnly, selectionOnly);
        context.getViewRoot().visitTree(visitContext, (VisitCallback)visitCallback);
        if (postProcessor != null) {
            postProcessor.invoke(context.getELContext(), new Object[]{wb});
        }
        this.writeExcelToResponse(context.getExternalContext(), wb, filename);
    }

    @Override
    protected void exportCells(DataTable table, Object document) {
        Sheet sheet = (Sheet)document;
        int sheetRowIndex = sheet.getLastRowNum() + 1;
        Row row = sheet.createRow(sheetRowIndex);
        for (UIColumn col : table.getColumns()) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            this.addColumnValue(row, col.getChildren(), col);
        }
    }

    protected void addColumnFacets(DataTable table, Sheet sheet, Exporter.ColumnType columnType) {
        int sheetRowIndex = columnType.equals((Object)Exporter.ColumnType.HEADER) ? 0 : sheet.getLastRowNum() + 1;
        Row rowHeader = sheet.createRow(sheetRowIndex);
        for (UIColumn col : table.getColumns()) {
            String textValue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (!col.isRendered() || !col.isExportable()) continue;
            UIComponent facet = col.getFacet(columnType.facet());
            if (facet != null) {
                this.addColumnValue(rowHeader, facet);
                continue;
            }
            switch (columnType) {
                case HEADER: {
                    textValue = col.getHeaderText();
                    break;
                }
                case FOOTER: {
                    textValue = col.getFooterText();
                    break;
                }
                default: {
                    textValue = "";
                }
            }
            this.addColumnValue(rowHeader, textValue);
        }
    }

    protected void addColumnValue(Row row, UIComponent component) {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        this.addColumnValue(row, value);
    }

    protected void addColumnValue(Row row, String value) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        cell.setCellValue(this.createRichTextString(value));
    }

    protected void addColumnValue(Row row, List<UIComponent> components, UIColumn column) {
        short cellIndex = row.getLastCellNum() == -1 ? (short)0 : row.getLastCellNum();
        Cell cell = row.createCell((int)cellIndex);
        FacesContext context = FacesContext.getCurrentInstance();
        if (column.getExportFunction() != null) {
            cell.setCellValue(this.createRichTextString(this.exportColumnByFunction(context, column)));
        } else {
            StringBuilder builder = new StringBuilder();
            for (UIComponent component : components) {
                String value;
                if (!component.isRendered() || (value = this.exportValue(context, component)) == null) continue;
                builder.append(value);
            }
            cell.setCellValue(this.createRichTextString(builder.toString()));
        }
    }

    protected RichTextString createRichTextString(String value) {
        return new HSSFRichTextString(value);
    }

    protected Workbook createWorkBook() {
        return new HSSFWorkbook();
    }

    protected void writeExcelToResponse(ExternalContext externalContext, Workbook generatedExcel, String filename) throws IOException {
        externalContext.setResponseContentType("application/vnd.ms-excel");
        externalContext.setResponseHeader("Expires", "0");
        externalContext.setResponseHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        externalContext.setResponseHeader("Pragma", "public");
        externalContext.setResponseHeader("Content-disposition", this.getContentDisposition(filename));
        externalContext.addResponseCookie("primefaces.download", "true", Collections.emptyMap());
        OutputStream out = externalContext.getResponseOutputStream();
        generatedExcel.write(out);
        externalContext.responseFlushBuffer();
    }

    protected String getContentDisposition(String filename) {
        return "attachment;filename=" + filename + ".xls";
    }

    public void exportTable(FacesContext context, DataTable table, Sheet sheet, boolean pageOnly, boolean selectionOnly) {
        this.addColumnFacets(table, sheet, Exporter.ColumnType.HEADER);
        if (pageOnly) {
            this.exportPageOnly(context, table, sheet);
        } else if (selectionOnly) {
            this.exportSelectionOnly(context, table, sheet);
        } else {
            this.exportAll(context, table, sheet);
        }
        if (table.hasFooterColumn()) {
            this.addColumnFacets(table, sheet, Exporter.ColumnType.FOOTER);
        }
        table.setRowIndex(-1);
    }
}

