/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.ExcelExporter;

public class ExcelExportVisitCallback
implements VisitCallback {
    private ExcelExporter exporter;
    private boolean pageOnly;
    private boolean selectionOnly;
    private Workbook workbook;

    public ExcelExportVisitCallback(ExcelExporter exporter, Workbook workbook, boolean pageOnly, boolean selectionOnly) {
        this.exporter = exporter;
        this.pageOnly = pageOnly;
        this.selectionOnly = selectionOnly;
        this.workbook = workbook;
    }

    public VisitResult visit(VisitContext context, UIComponent target) {
        DataTable dt = (DataTable)target;
        FacesContext facesContext = context.getFacesContext();
        String sheetName = this.exporter.getSheetName(facesContext, dt);
        if (sheetName == null) {
            sheetName = dt.getClientId().replaceAll(":", "_");
        }
        Sheet sheet = this.workbook.createSheet(sheetName);
        this.exporter.exportTable(facesContext, dt, sheet, this.pageOnly, this.selectionOnly);
        return VisitResult.ACCEPT;
    }
}

