/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dock;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dock.Dock;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.util.WidgetBuilder;

public class DockRenderer
extends BaseMenuRenderer {
    protected void encodeScript(FacesContext context, AbstractMenu menu) throws IOException {
        Dock dock = (Dock)menu;
        String clientId = dock.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Dock", dock.resolveWidgetVar(), clientId).attr("position", dock.getPosition()).attr("maxWidth", dock.getMaxWidth()).attr("itemWidth", dock.getItemWidth()).attr("proximity", dock.getProximity()).attr("halign", dock.getHalign());
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Dock dock = (Dock)menu;
        String clientId = dock.getClientId(context);
        String position = dock.getPosition();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)("ui-dock-" + position + " ui-widget"), "styleClass");
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)("ui-dock-container-" + position + " ui-widget-header"), null);
        this.encodeMenuItems(context, dock);
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeMenuItems(FacesContext context, Dock dock) throws IOException {
        if (dock.getElementsCount() > 0) {
            List menuElements = dock.getElements();
            for (MenuElement element : menuElements) {
                if (!element.isRendered() || !(element instanceof MenuItem)) continue;
                this.encodeMenuItem(context, dock, (MenuItem)element);
            }
        }
    }

    protected void encodeMenuItemContent(FacesContext context, AbstractMenu menu, MenuItem menuitem) throws IOException {
        String position = ((Dock)menu).getPosition();
        if (position.equalsIgnoreCase("top")) {
            this.encodeItemIcon(context, menuitem);
            this.encodeItemLabel(context, menuitem);
        } else {
            this.encodeItemLabel(context, menuitem);
            this.encodeItemIcon(context, menuitem);
        }
    }

    protected void encodeItemIcon(FacesContext context, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("img", null);
        writer.writeAttribute("src", (Object)this.getResourceURL(context, menuitem.getIcon()), null);
        writer.endElement("img");
    }

    protected void encodeItemLabel(FacesContext context, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        if (menuitem.getValue() != null) {
            writer.write((String)menuitem.getValue());
        }
        writer.endElement("span");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

