/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.diagram;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.PrimeClientBehaviorHolder;
import org.primefaces.component.api.Widget;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.diagram.ConnectEvent;
import org.primefaces.event.diagram.ConnectionChangeEvent;
import org.primefaces.event.diagram.DisconnectEvent;
import org.primefaces.model.diagram.DiagramModel;
import org.primefaces.model.diagram.Element;
import org.primefaces.model.diagram.endpoint.EndPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="diagram/diagram.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="diagram/diagram.js")})
public class Diagram
extends UIOutput
implements Widget,
ClientBehaviorHolder,
PrimeClientBehaviorHolder {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Diagram";
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    private static final String DEFAULT_RENDERER = "org.primefaces.component.DiagramRenderer";
    public static final String CONTAINER_CLASS = "ui-diagram ui-widget";
    public static final String ELEMENT_CLASS = "ui-diagram-element";
    public static final String DRAGGABLE_ELEMENT_CLASS = "ui-diagram-draggable";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = Collections.unmodifiableMap(new HashMap<String, Class<? extends BehaviorEvent>>(){
        {
            this.put("connect", ConnectEvent.class);
            this.put("disconnect", DisconnectEvent.class);
            this.put("connectionChange", ConnectionChangeEvent.class);
        }
    });
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    public Diagram() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.widgetVar), null);
    }

    public void setWidgetVar(String _widgetVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.widgetVar), (Object)_widgetVar);
    }

    public String getVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.var), null);
    }

    public void setVar(String _var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), (Object)_var);
    }

    public String getStyle() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.style), null);
    }

    public void setStyle(String _style) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.style), (Object)_style);
    }

    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.styleClass), null);
    }

    public void setStyleClass(String _styleClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.styleClass), (Object)_styleClass);
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public boolean isConnectRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_connect");
    }

    public boolean isDisconnectRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_disconnect");
    }

    public boolean isConnectionChangeRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_connectionChange");
    }

    private boolean isRequestSource(FacesContext context) {
        return this.getClientId(context).equals(context.getExternalContext().getRequestParameterMap().get("javax.faces.source"));
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (this.isRequestSource(context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            DiagramModel model = (DiagramModel)this.getValue();
            if (model != null) {
                if (eventName.equals("connect") || eventName.equals("disconnect")) {
                    AbstractAjaxBehaviorEvent facesEvent = null;
                    Element sourceElement = model.findElement((String)params.get(clientId + "_sourceId"));
                    Element targetElement = model.findElement((String)params.get(clientId + "_targetId"));
                    EndPoint sourceEndPoint = model.findEndPoint(sourceElement, (String)params.get(clientId + "_sourceEndPointId"));
                    EndPoint targetEndPoint = model.findEndPoint(targetElement, (String)params.get(clientId + "_targetEndPointId"));
                    if (eventName.equals("connect")) {
                        facesEvent = new ConnectEvent((UIComponent)this, behaviorEvent.getBehavior(), sourceElement, targetElement, sourceEndPoint, targetEndPoint);
                    } else if (eventName.equals("disconnect")) {
                        facesEvent = new DisconnectEvent((UIComponent)this, behaviorEvent.getBehavior(), sourceElement, targetElement, sourceEndPoint, targetEndPoint);
                    }
                    facesEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)facesEvent);
                } else if (eventName.equals("connectionChange")) {
                    Element originalSourceElement = model.findElement((String)params.get(clientId + "_originalSourceId"));
                    Element newSourceElement = model.findElement((String)params.get(clientId + "_newSourceId"));
                    Element originalTargetElement = model.findElement((String)params.get(clientId + "_originalTargetId"));
                    Element newTargetElement = model.findElement((String)params.get(clientId + "_newTargetId"));
                    EndPoint originalSourceEndPoint = model.findEndPoint(originalSourceElement, (String)params.get(clientId + "_originalSourceEndPointId"));
                    EndPoint newSourceEndPoint = model.findEndPoint(newSourceElement, (String)params.get(clientId + "_newSourceEndPointId"));
                    EndPoint originalTargetEndPoint = model.findEndPoint(originalTargetElement, (String)params.get(clientId + "_originalTargetEndPointId"));
                    EndPoint newTargetEndPoint = model.findEndPoint(newTargetElement, (String)params.get(clientId + "_targetEndPointId"));
                    ConnectionChangeEvent connectionChangeEvent = new ConnectionChangeEvent((UIComponent)this, behaviorEvent.getBehavior(), originalSourceElement, newSourceElement, originalTargetElement, newTargetElement, originalSourceEndPoint, newSourceEndPoint, originalTargetEndPoint, newTargetEndPoint);
                    connectionChangeEvent.setPhaseId(behaviorEvent.getPhaseId());
                    super.queueEvent((FacesEvent)connectionChangeEvent);
                }
            }
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public String resolveWidgetVar() {
        FacesContext context = this.getFacesContext();
        String userWidgetVar = (String)this.getAttributes().get("widgetVar");
        if (userWidgetVar != null) {
            return userWidgetVar;
        }
        return "widget_" + this.getClientId(context).replaceAll("-|" + UINamingContainer.getSeparatorChar((FacesContext)context), "_");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        widgetVar,
        var,
        style,
        styleClass;

        String toString;

        private PropertyKeys(String toString) {
            this.toString = toString;
        }

        private PropertyKeys() {
        }

        public String toString() {
            return this.toString != null ? this.toString : super.toString();
        }
    }
}

