/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.commandlink;

import java.io.IOException;
import java.util.ArrayList;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.component.commandlink.CommandLink;
import org.primefaces.context.RequestContext;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.CSVBuilder;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.SharedStringBuilder;

public class CommandLinkRenderer
extends CoreRenderer {
    private static final String SB_BUILD_ONCLICK = CommandLinkRenderer.class.getName() + "#buildOnclick";

    public void decode(FacesContext context, UIComponent component) {
        CommandLink link = (CommandLink)component;
        if (link.isDisabled()) {
            return;
        }
        String param = component.getClientId(context);
        if (context.getExternalContext().getRequestParameterMap().containsKey(param)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        CommandLink link = (CommandLink)component;
        String clientId = link.getClientId(context);
        Object label = link.getValue();
        if (!link.isDisabled()) {
            String request;
            String onclickBehaviors;
            boolean ajax = link.isAjax();
            String styleClass = link.getStyleClass();
            styleClass = styleClass == null ? "ui-commandlink ui-widget" : "ui-commandlink ui-widget " + styleClass;
            RequestContext requestContext = RequestContext.getCurrentInstance();
            boolean csvEnabled = requestContext.getApplicationContext().getConfig().isClientSideValidationEnabled() && link.isValidateClient();
            StringBuilder onclick = SharedStringBuilder.get(context, SB_BUILD_ONCLICK);
            if (link.getOnclick() != null) {
                onclick.append(link.getOnclick()).append(";");
            }
            if ((onclickBehaviors = this.getEventBehaviors(context, (ClientBehaviorHolder)link, "click", null)) != null) {
                onclick.append(onclickBehaviors);
            }
            writer.startElement("a", (UIComponent)link);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            if (link.getTitle() != null) {
                writer.writeAttribute("aria-label", (Object)link.getTitle(), null);
            }
            if (ajax) {
                request = this.buildAjaxRequest(context, link, null);
            } else {
                UIForm form = ComponentTraversalUtils.closestForm(context, (UIComponent)link);
                if (form == null) {
                    throw new FacesException("Commandlink \"" + clientId + "\" must be inside a form component");
                }
                request = this.buildNonAjaxRequest(context, (UIComponent)link, (UIComponent)form, clientId, true);
            }
            if (csvEnabled) {
                CSVBuilder csvb = requestContext.getCSVBuilder();
                request = csvb.init().source("this").ajax(ajax).process((UIComponent)link, link.getProcess()).update((UIComponent)link, link.getUpdate()).command(request).build();
            }
            onclick.append(request);
            if (onclick.length() > 0) {
                if (link.requiresConfirmation()) {
                    writer.writeAttribute("data-pfconfirmcommand", (Object)onclick.toString(), null);
                    writer.writeAttribute("onclick", (Object)link.getConfirmationScript(), "onclick");
                } else {
                    writer.writeAttribute("onclick", (Object)onclick.toString(), "onclick");
                }
            }
            ArrayList<ClientBehaviorContext.Parameter> behaviorParams = new ArrayList<ClientBehaviorContext.Parameter>();
            behaviorParams.add(new ClientBehaviorContext.Parameter("CLIENT_BEHAVIOR_RENDERING_MODE", (Object)ClientBehaviorRenderingMode.UNOBSTRUSIVE));
            String dialogReturnBehavior = this.getEventBehaviors(context, (ClientBehaviorHolder)link, "dialogReturn", behaviorParams);
            if (dialogReturnBehavior != null) {
                writer.writeAttribute("data-dialogreturn", (Object)dialogReturnBehavior, null);
            }
            this.renderPassThruAttributes(context, (UIComponent)link, HTML.LINK_ATTRS, HTML.CLICK_EVENT);
            if (label != null) {
                writer.writeText(label, "value");
            } else {
                this.renderChildren(context, (UIComponent)link);
            }
            writer.endElement("a");
        } else {
            String styleClass = link.getStyleClass();
            styleClass = styleClass == null ? "ui-commandlink ui-widget ui-state-disabled" : "ui-commandlink ui-widget ui-state-disabled " + styleClass;
            writer.startElement("span", (UIComponent)link);
            writer.writeAttribute("id", (Object)clientId, "id");
            writer.writeAttribute("class", (Object)styleClass, "styleclass");
            if (link.getStyle() != null) {
                writer.writeAttribute("style", (Object)link.getStyle(), "style");
            }
            if (label != null) {
                writer.writeText(label, "value");
            } else {
                this.renderChildren(context, (UIComponent)link);
            }
            writer.endElement("span");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

