/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import java.util.ArrayList;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.primefaces.util.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicResourcesPhaseListener
implements PhaseListener {
    private static final String INITIAL_RESOURCES = DynamicResourcesPhaseListener.class.getName() + ".INITIAL_RESOURCES";

    public void beforePhase(PhaseEvent event) {
    }

    public void afterPhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (context.getViewRoot() == null || !context.getPartialViewContext().isAjaxRequest()) {
            return;
        }
        ArrayList<ResourceUtils.ResourceInfo> initialResources = ResourceUtils.getComponentResources(context);
        DynamicResourcesPhaseListener.putInitialResources(context, initialResources);
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public static void putInitialResources(FacesContext context, ArrayList<ResourceUtils.ResourceInfo> resources) {
        context.getAttributes().put(INITIAL_RESOURCES, resources);
    }

    public static ArrayList<ResourceUtils.ResourceInfo> getInitialResources(FacesContext context) {
        return (ArrayList)context.getAttributes().get(INITIAL_RESOURCES);
    }
}

