/*
 * Decompiled with CFR 0.152.
 */
package org.jblas.util;

import java.util.Random;
import org.jblas.DoubleMatrix;
import org.jblas.FloatMatrix;

public class Permutations {
    public static int[] randomPermutation(int size) {
        int j;
        Random r = new Random();
        int[] result = new int[size];
        for (j = 0; j < size; ++j) {
            result[j] = j;
        }
        for (j = size - 1; j > 0; --j) {
            int k = r.nextInt(j);
            int temp = result[j];
            result[j] = result[k];
            result[k] = temp;
        }
        return result;
    }

    public static int[] randomSubset(int k, int n) {
        assert (0 < k && k <= n);
        Random r = new Random();
        int t = 0;
        int m = 0;
        int[] result = new int[k];
        while (m < k) {
            double u = r.nextDouble();
            if ((double)(n - t) * u < (double)(k - m)) {
                result[m] = t;
                ++m;
            }
            ++t;
        }
        return result;
    }

    public static DoubleMatrix permutationDoubleMatrixFromPivotIndices(int size, int[] ipiv) {
        int i;
        int n = ipiv.length;
        int[] indices = new int[size];
        for (i = 0; i < size; ++i) {
            indices[i] = i;
        }
        for (i = 0; i < n; ++i) {
            int j = ipiv[i] - 1;
            int t = indices[i];
            indices[i] = indices[j];
            indices[j] = t;
        }
        DoubleMatrix result = new DoubleMatrix(size, size);
        for (int i2 = 0; i2 < size; ++i2) {
            result.put(indices[i2], i2, 1.0);
        }
        return result;
    }

    public static FloatMatrix permutationFloatMatrixFromPivotIndices(int size, int[] ipiv) {
        int i;
        int n = ipiv.length;
        int[] indices = new int[size];
        for (i = 0; i < size; ++i) {
            indices[i] = i;
        }
        for (i = 0; i < n; ++i) {
            int j = ipiv[i] - 1;
            int t = indices[i];
            indices[i] = indices[j];
            indices[j] = t;
        }
        FloatMatrix result = new FloatMatrix(size, size);
        for (int i2 = 0; i2 < size; ++i2) {
            result.put(indices[i2], i2, 1.0f);
        }
        return result;
    }
}

