/*
 * Decompiled with CFR 0.152.
 */
package com.jujutsu.utils;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.ejml.data.DenseMatrix64F;
import org.jblas.ComplexDoubleMatrix;
import org.jblas.DoubleMatrix;
import org.jblas.Eigen;
import org.netlib.util.intW;

public class BlasOps {
    void benchmark(int size) {
        int m = (int)Math.sqrt(size);
        double[] a = new double[m * m];
        a[0] = 2.0;
        a[4] = 2.0;
        a[8] = 2.0;
        DoubleMatrix pInv = new DoubleMatrix(a);
        System.out.println("Start is: " + pInv.reshape(m, m));
        double[] aOrig = Arrays.copyOf(a, a.length);
        double[] b = new double[1];
        int[] p = new int[m];
        intW info = new intW(0);
        LAPACK.getInstance().dgetri(m, a, m, p, b, -1, info);
        b = new double[(int)b[0]];
        LAPACK.getInstance().dgetrf(m, m, a, m, p, info);
        if (info.val != 0) {
            throw new IllegalArgumentException();
        }
        LAPACK.getInstance().dgetri(m, a, m, p, b, b.length, info);
        if (info.val != 0) {
            throw new IllegalArgumentException();
        }
        double[] c = new double[m * m];
        BLAS.getInstance().dgemm("N", "N", m, m, m, 1.0, aOrig, m, a, m, 0.0, c, m);
        pInv = new DoubleMatrix(a);
        System.out.println("Result is: " + pInv.reshape(m, m));
        System.out.println("BlasInvert Result is: " + BlasOps.blasInvert(new DoubleMatrix(a)));
    }

    public static DoubleMatrix blasInvert(DoubleMatrix myPrecision) {
        double[] b = new double[myPrecision.columns];
        int[] p = new int[myPrecision.columns];
        intW info = new intW(0);
        int m = myPrecision.columns;
        double[] a = myPrecision.toArray();
        LAPACK.getInstance().dgetrf(m, m, a, m, p, info);
        if (info.val != 0) {
            throw new IllegalArgumentException();
        }
        LAPACK.getInstance().dgetri(m, a, m, p, b, b.length, info);
        if (info.val != 0) {
            throw new IllegalArgumentException();
        }
        DoubleMatrix pInv = new DoubleMatrix(a);
        return pInv.reshape(myPrecision.rows, myPrecision.columns);
    }

    public static DenseMatrix64F blasInvertDense(DenseMatrix64F myPrecision) {
        DoubleMatrix mp = new DoubleMatrix((double[])myPrecision.getData().clone());
        mp = mp.reshape(myPrecision.numRows, myPrecision.numCols);
        DoubleMatrix inv = BlasOps.blasInvert(mp);
        DenseMatrix64F res = new DenseMatrix64F(inv.toArray2());
        return res;
    }

    public static DoubleMatrix square(DoubleMatrix in) {
        DoubleMatrix res = in.dup();
        for (int i = 0; i < res.getLength(); ++i) {
            double val = res.get(i);
            res.put(i, val * val);
        }
        return res;
    }

    public static DoubleMatrix scalarInverse(DoubleMatrix in) {
        DoubleMatrix res = in.dup();
        for (int i = 0; i < res.getLength(); ++i) {
            double val = res.get(i);
            res.put(i, 1.0 / val);
        }
        return res;
    }

    public static void assignAtIndex(DoubleMatrix num, int[] range, int[] range1, double value) {
        for (int j = 0; j < range.length; ++j) {
            num.put(range[j], range1[j], value);
        }
    }

    public static boolean[][] equal(DoubleMatrix matrix1, DoubleMatrix matrix2) {
        boolean[][] equals = new boolean[matrix1.rows][matrix1.columns];
        if (matrix1.length != matrix2.length) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        if (matrix1.columns != matrix2.columns) {
            throw new IllegalArgumentException("Dimensions does not match");
        }
        for (int i = 0; i < matrix1.rows; ++i) {
            for (int j = 0; j < matrix1.columns; ++j) {
                equals[i][j] = Double.compare(matrix1.get(i, j), matrix2.get(i, j)) == 0;
            }
        }
        return equals;
    }

    public static void assignAllLessThan(DoubleMatrix matrix, double lessthan, double assign) {
        for (int i = 0; i < matrix.length; ++i) {
            if (!(matrix.get(i) < lessthan)) continue;
            matrix.put(i, assign);
        }
    }

    public static DoubleMatrix log(DoubleMatrix m1) {
        DoubleMatrix matrix = m1.dup();
        for (int i = 0; i < matrix.length; ++i) {
            matrix.put(i, Math.log(m1.get(i)));
        }
        return matrix;
    }

    public static DoubleMatrix log(DoubleMatrix m1, boolean infAsZero) {
        DoubleMatrix matrix = m1.dup();
        for (int i = 0; i < matrix.length; ++i) {
            matrix.put(i, Math.log(m1.get(i)));
            if (!infAsZero || !Double.isInfinite(matrix.get(i))) continue;
            matrix.put(i, 0.0);
        }
        return matrix;
    }

    public static DoubleMatrix replaceNaN(DoubleMatrix matrix, double repl) {
        DoubleMatrix result = matrix.dup();
        for (int i = 0; i < matrix.length; ++i) {
            if (Double.isNaN(matrix.get(i))) {
                result.put(i, repl);
                continue;
            }
            result.put(i, matrix.get(i));
        }
        return result;
    }

    public static DoubleMatrix tile(DoubleMatrix matrix, int rowtimes, int coltimes) {
        DoubleMatrix result = new DoubleMatrix(matrix.rows * rowtimes, matrix.columns * coltimes);
        int resultrow = 0;
        for (int i = 0; i < rowtimes; ++i) {
            for (int j = 0; j < matrix.rows; ++j) {
                int resultcol = 0;
                for (int k = 0; k < coltimes; ++k) {
                    for (int l = 0; l < matrix.columns; ++l) {
                        result.put(resultrow, resultcol++, matrix.get(j, l));
                    }
                }
                ++resultrow;
            }
        }
        return result;
    }

    public static boolean[][] biggerThan(DoubleMatrix matrix, double value) {
        boolean[][] equals = new boolean[matrix.rows][matrix.columns];
        for (int i = 0; i < matrix.rows; ++i) {
            for (int j = 0; j < matrix.columns; ++j) {
                equals[i][j] = Double.compare(matrix.get(i, j), value) == 1;
            }
        }
        return equals;
    }

    public static DoubleMatrix abs(boolean[][] booleans) {
        DoubleMatrix absolutes = new DoubleMatrix(booleans.length, booleans[0].length);
        for (int i = 0; i < booleans.length; ++i) {
            for (int j = 0; j < booleans[0].length; ++j) {
                absolutes.put(i, j, booleans[i][j] ? 1.0 : 0.0);
            }
        }
        return absolutes;
    }

    public static DoubleMatrix exp(DoubleMatrix m1) {
        DoubleMatrix matrix = m1.dup();
        for (int i = 0; i < matrix.length; ++i) {
            matrix.put(i, Math.exp(m1.get(i)));
        }
        return matrix;
    }

    public static boolean containsNaNs(DoubleMatrix matrix) {
        for (int i = 0; i < matrix.length; ++i) {
            if (!Double.isNaN(matrix.get(i))) continue;
            return true;
        }
        return false;
    }

    public static DoubleMatrix sign(DoubleMatrix matrix) {
        DoubleMatrix signs = new DoubleMatrix(matrix.rows, matrix.columns);
        for (int i = 0; i < matrix.length; ++i) {
            signs.put(i, matrix.get(i) >= 0.0 ? 1.0 : -1.0);
        }
        return signs;
    }

    public static DoubleMatrix sqrt(DoubleMatrix m1) {
        DoubleMatrix matrix = m1.dup();
        for (int i = 0; i < matrix.length; ++i) {
            matrix.put(i, Math.sqrt(m1.get(i)));
        }
        return matrix;
    }

    public static DoubleMatrix pca(DoubleMatrix source, int dimension) {
        DoubleMatrix covMatrix = source.mmul(source.transpose()).div(source.columns);
        ComplexDoubleMatrix eigVal = Eigen.eigenvalues(covMatrix);
        ComplexDoubleMatrix[] eigVectorsVal = Eigen.eigenvectors(covMatrix);
        ComplexDoubleMatrix eigVectors = eigVectorsVal[0];
        ArrayList<PCABean> beans = new ArrayList<PCABean>();
        for (int i = 0; i < eigVectors.columns; ++i) {
            beans.add(new PCABean(eigVal.get(i).real(), eigVectors.getColumn(i)));
        }
        Collections.sort(beans);
        DoubleMatrix newVec = new DoubleMatrix(dimension, ((PCABean)beans.get((int)0)).vector.rows);
        for (int i = 0; i < dimension; ++i) {
            ComplexDoubleMatrix dm = ((PCABean)beans.get((int)i)).vector;
            DoubleMatrix real = dm.getReal();
            newVec.putRow(i, real);
        }
        return newVec.mmul(source);
    }

    static class PCABean
    implements Comparable<PCABean> {
        double eigenValue;
        ComplexDoubleMatrix vector;

        public PCABean(double eigenValue, ComplexDoubleMatrix vector) {
            this.eigenValue = eigenValue;
            this.vector = vector;
        }

        @Override
        public int compareTo(PCABean o) {
            return Double.compare(o.eigenValue, this.eigenValue);
        }

        public String toString() {
            return "PCABean [eigenValue=" + this.eigenValue + ", vector=" + this.vector + "]";
        }
    }
}

