/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.json;

import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class PrettyWriter {
    static int inc = 4;
    StringBuilder builder = new StringBuilder();
    JsonStructure json;

    public String getPrettyJson() {
        return this.builder.toString();
    }

    public void write(String jsonStr) {
        StringReader stringReader = new StringReader(jsonStr);
        try {
            this.json = Json.createReader((Reader)stringReader).read();
        }
        catch (Exception exc) {
            boolean bl = false;
        }
        if (this.json instanceof JsonObject) {
            this.writeObject((JsonObject)this.json, 0);
        } else if (this.json instanceof JsonArray) {
            this.writeArray((JsonArray)this.json, 0);
        }
    }

    public void write(JsonValue jsonValue, int indent) {
        if (jsonValue instanceof JsonArray) {
            this.writeArray((JsonArray)jsonValue, indent);
        } else if (jsonValue instanceof JsonObject) {
            this.writeObject((JsonObject)jsonValue, indent);
        } else if (jsonValue instanceof JsonString) {
            this.writeString((JsonString)jsonValue);
        } else if (jsonValue instanceof JsonNumber) {
            this.writeNumber((JsonNumber)jsonValue);
        }
    }

    public void writeString(JsonString jsonString) {
        this.builder.append(jsonString.getString());
    }

    public void writeNumber(JsonNumber jsonNumber) {
        this.builder.append(jsonNumber.doubleValue());
    }

    public void writeObject(JsonObject jsonObject, int indent) {
        this.writeIndent(indent);
        this.builder.append("{\n");
        for (String key : jsonObject.keySet()) {
            JsonValue jsonValue = (JsonValue)jsonObject.get((Object)key);
            this.writeIndent(indent);
            this.builder.append(key);
            this.builder.append(',');
            if (jsonValue instanceof JsonStructure) {
                this.builder.append("\n");
                this.write(jsonValue, indent + inc);
                continue;
            }
            this.write(jsonValue, indent);
            this.builder.append("\n");
        }
        this.writeIndent(indent);
        this.builder.append("}\n");
    }

    public void writeArray(JsonArray jsonArray, int indent) {
        this.writeIndent(indent);
        this.builder.append("[\n");
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonValue jsonValue = (JsonValue)jsonArray.get(i);
            if (!(jsonValue instanceof JsonStructure)) {
                this.writeIndent(indent);
            }
            this.write(jsonValue, indent);
            this.builder.append("\n");
        }
        this.writeIndent(indent);
        this.builder.append("]\n");
    }

    private void writeIndent(int indent) {
        for (int i = 0; i < indent; ++i) {
            this.builder.append(' ');
        }
    }

    public JsonObject getJson() {
        return (JsonObject)this.json;
    }
}

