/*
 * Decompiled with CFR 0.152.
 */
package org.rhwlab.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;

public class EncodeObject {
    JsonObject schemaProps;

    public EncodeObject(JsonObject schemaObject) {
        this.schemaProps = schemaObject.getJsonObject("properties");
    }

    public JsonObject build(Map<String, String> data, Map<String, String> mapping) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (String dataKey : data.keySet()) {
            String encodeKey = mapping.get(dataKey);
            JsonObject jsonObject = this.schemaProps.getJsonObject(encodeKey);
        }
        return builder.build();
    }

    public List<String> propertyTypes(String property) {
        ArrayList<String> ret = new ArrayList<String>();
        JsonObject propObject = this.schemaProps.getJsonObject(property);
        JsonValue typeValue = (JsonValue)propObject.get((Object)"type");
        if (typeValue instanceof JsonString) {
            ret.add(((JsonString)typeValue).getString());
        } else if (typeValue instanceof JsonArray) {
            JsonArray typeArray = (JsonArray)typeValue;
            for (JsonValue arrayValue : typeArray) {
                ret.add(((JsonString)arrayValue).getString());
            }
        }
        return ret;
    }

    public String itemType(String property) {
        String ret = null;
        JsonObject propObject = this.schemaProps.getJsonObject(property);
        JsonObject itemsObject = propObject.getJsonObject("items");
        ret = itemsObject.getJsonString("type").getString();
        return ret;
    }
}

